% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneMatchR.R
\name{geneMatchR}
\alias{geneMatchR}
\title{Generic geneMatchR function}
\usage{
geneMatchR(
  data1,
  data2,
  data1Names = NULL,
  data2Names = NULL,
  merge = FALSE,
  ...
)
}
\arguments{
\item{data1}{a data matrix, typically genes by samples}

\item{data2}{an amplitude matrix, typically genes by factors}

\item{data1Names}{rownames of data matrix, for eg genenames}

\item{data2Names}{rownames of amplitude matrix to be matched to rownames of datamatrix}

\item{merge}{logical indicating wether or not to merged data sets}

\item{...}{Additional arguments to geneMatchR}
}
\value{
A list of genes (intersection) in both datasets. (if merge = TRUE, Also returns merged data.)
}
\description{
Matches genes accross datasets
}
\examples{
geneMatchR(data1=p.ESepiGen4c1l$mRNA.Seq,data2=p.RNAseq6l3c3t,
data1Names=map.ESepiGen4c1l[["GeneSymbols"]])

}
