% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMethods.R
\docType{methods}
\name{summarize}
\alias{summarize}
\alias{summarize,profileplyr-method}
\title{summarize the rows of a deepTools matrix}
\usage{
summarize(
  object = "profileplyr",
  fun = "function",
  output = "character",
  keep_all_mcols = "logical",
  sampleData_columns_for_longPlot = "character"
)

\S4method{summarize}{profileplyr}(
  object = "profileplyr",
  fun = "function",
  output = "character",
  keep_all_mcols = FALSE,
  sampleData_columns_for_longPlot = NULL
)
}
\arguments{
\item{object}{A profileplyr object}

\item{fun}{the function used to summarize the ranges (e.g. rowMeans or rowMax)}

\item{output}{Must be either "matrix", "long", or "object".}

\item{keep_all_mcols}{if output is 'long' and this is set to TRUE, then all metadata columns in the rowRanges will be included in the output. If FALSE (default value), then only the column indicated in the 'rowGroupsInUse' slot of the metadata will be included in the output dataframe.}

\item{sampleData_columns_for_longPlot}{If output is set to 'long', then this argument can be used to add information stored in sampleData(object) to the summarized data frame. This needs to be a character vector with elements matching coumn names in sampleData(object).}
}
\value{
If output="matrix" returns a matrix, if output="long" returns a data.frame in long format,  if output="object" returns a SummarizedExperiment object with the summarized matrix.
}
\description{
summarize the rows of a deepTools matrix
}
\details{
Takes a SE object and outputs a summarized experiment object with a matrix containing ranges as rows and each sample having one column with summary statistic
}
\section{Methods (by class)}{
\itemize{
\item \code{summarize(profileplyr)}: summarize the rows of a deepTools matrix

}}
\examples{
example <- system.file("extdata", "example_deepTools_MAT", package = "profileplyr") 
object <- import_deepToolsMat(example)

# output matrix (can be used to make a heatmap)

object_sumMat <- summarize(object, fun = rowMeans, output = "matrix") 

# output long dataframe for ggplot

object_long <- summarize(object, fun = rowMeans, output = "long") 
object_long[1:3, ]

library(ggplot2)
ggplot(object_long, aes(x = Sample, y = log(Signal))) + geom_boxplot()

# output profileplyr object containing summarized matrix

summarize(object, fun = rowMeans, output = "object")
}
