% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMethods.R
\docType{methods}
\name{annotateRanges}
\alias{annotateRanges}
\alias{annotateRanges,profileplyr-method}
\title{Annotate profileplyr ranges to genes using ChIPseeker}
\usage{
annotateRanges(
  object = "profileplyr",
  annotation_subset = "character",
  TxDb,
  annoDb = "character",
  tssRegion = "numeric",
  changeGroupToAnnotation = "logical",
  heatmap_grouping = "character",
  ...
)

\S4method{annotateRanges}{profileplyr}(
  object = "profileplyr",
  annotation_subset = NULL,
  TxDb = NULL,
  annoDb = NULL,
  tssRegion = c(-3000, 3000),
  changeGroupToAnnotation = FALSE,
  heatmap_grouping = "group",
  ...
)
}
\arguments{
\item{object}{A profileplyr object}

\item{annotation_subset}{If specific annotations (from ChIPseeker package) are desired, specify them here in a character vector. Can be one or any combination of "Promoter", "Exon", "Intron", "Downstream", "Distal Intergenic", "3p UTR", or "5p UTR". This argument is optional and all annotation types will be included if argument is left out.}

\item{TxDb}{This must be either a TxDb object, a character string that is a path to a GTF file, or character string indicating genome if one of the following - "hg19", "hg38", "mm9", "mm10".}

\item{annoDb}{The annotation package to be used. If the 'TxDb' argument is set to "hg19", "hg38", "mm9", or "mm10" this will automatically be set and this can be left as NULL.}

\item{tssRegion}{This needs to be a vector of two numbers that will define promoter regions. The first number must be negative, while the second number must be positive. Default values are  c(-3000, 3000)}

\item{changeGroupToAnnotation}{If the grouping should be changed to the annotations (typically when the ranges will be exported for visualization based on this annotation), this should be TRUE. The default if FALSE, which will keep the grouping that existed before annotating the object. This is typical if the output will be used for finding overlaps with gene lists in the 'groupBy' function.}

\item{heatmap_grouping}{Only relevant if 'keepAnnotationAsGroup' is set to TRUE. This argument needs to be either "group", or "annotation". This will determine how the ranges are grouped in the resulting object. Default is heatmap_grouping = "Group". If there are no groups in the deepTools matrix that was used in the function, this argument is unnecessary}

\item{...}{pass to \code{\link[ChIPseeker]{annotatePeak}}}
}
\value{
A profileplyr object
}
\description{
The ranges from the deepTools matrix will be subset based on whether they overlap with specified annotated regions (using ChIPseeker) throughout the genome
}
\details{
tbd
}
\section{Methods (by class)}{
\itemize{
\item \code{annotateRanges(profileplyr)}: Annotate profileplyr ranges to genes using ChIPseeker

}}
\examples{
library(SummarizedExperiment)
example <- system.file("extdata", "example_deepTools_MAT", package = "profileplyr") 
object <- import_deepToolsMat(example)
object <- object[1:2, , ] 

# annotate ranges with genes using ChIPseeker 
# (NOTE: can choose subset of annotations with 'annotation_subset' argument)

annotateRanges(object, TxDb = "mm10")

}
