% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict,proDAFit-method}
\alias{predict,proDAFit-method}
\title{Predict the parameters or values of additional proteins}
\usage{
\S4method{predict}{proDAFit}(
  object,
  newdata,
  newdesign,
  type = c("response", "feature_parameters"),
  ...
)
}
\arguments{
\item{object}{an 'proDAFit' object that is produced by \code{proDA()}.}

\item{newdata}{a matrix or a SummarizedExperiment which contains
the new abundances for which values are predicted.}

\item{newdesign}{a formula or design matrix that specifies the new structure
that will be fitted}

\item{type}{either "response" or "feature_parameters". Default:
\code{"response"}}

\item{...}{additional parameters for the construction of the
'proDAFit' object.}
}
\value{
If \code{type = "response"} a matrix with the same dimensions
  as \code{object}. Or, if \code{type = "feature_parameters"} a
  'proDAFit' object with the same hyper-parameters and column data
  as \code{object}, but new fitted \code{rowData()}.
}
\description{
This function can either predict the abundance matrix for proteins
(\code{type = "response"}) without missing values according to the
linear probabilistic dropout model, fitted with \code{proDA()}. Or, it
can predict the feature parameters for additional proteins given their
abundances including missing values after estimating the hyper-parameters
on a dataset with the same sample structure
(\code{type = "feature_parameters"}).
}
\details{
\strong{Note:} this method behaves a little different from what one might
expect from the classical \code{predict.lm()} function, because
\code{object} is not just a single set of coefficients for one fit, but
many fits (ie. one for each protein) with some more hyper-parameters. The
classical \code{predict} function predicts the response for new samples.
This function does not support this, instead it is useful for getting a
matrix without missing values for additional proteins.
}
