% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_tests.R
\name{pd_row_t_test}
\alias{pd_row_t_test}
\alias{pd_row_f_test}
\title{Row-wise tests of difference using the probabilistic dropout model}
\usage{
pd_row_t_test(
  X,
  Y,
  moderate_location = TRUE,
  moderate_variance = TRUE,
  alternative = c("two.sided", "greater", "less"),
  pval_adjust_method = "BH",
  location_prior_df = 3,
  max_iter = 20,
  epsilon = 0.001,
  return_fit = FALSE,
  verbose = FALSE
)

pd_row_f_test(
  X,
  ...,
  groups = NULL,
  moderate_location = TRUE,
  moderate_variance = TRUE,
  pval_adjust_method = "BH",
  location_prior_df = 3,
  max_iter = 20,
  epsilon = 0.001,
  return_fit = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{X, Y, ...}{the matrices for condition 1, 2 and so on. They must
have the same number of rows.}

\item{moderate_location}{boolean values
to indicate if the location and the variances are
moderated. Default: \code{TRUE}}

\item{moderate_variance}{boolean values
to indicate if the location and the variances are
moderated. Default: \code{TRUE}}

\item{alternative}{a string that decides how the
hypothesis test is done. This parameter is only relevant for
the Wald-test specified using the `contrast` argument.
Default: \code{"two.sided"}}

\item{pval_adjust_method}{a string the indicates the method
that is used to adjust the p-value for the multiple testing.
It must match the options in \code{\link[stats]{p.adjust}}.
Default: \code{"BH"}}

\item{location_prior_df}{the number of degrees of freedom used
for the location prior. A large number (> 30) means that the
prior is approximately Normal. Default: \code{3}}

\item{max_iter}{the maximum of iterations \code{proDA()} tries
to converge to the hyper-parameter estimates. Default:
\code{20}}

\item{epsilon}{if the remaining error is smaller than \code{epsilon}
the model has converged. Default: \code{1e-3}}

\item{return_fit}{boolean that signals that in addition to the
data.frame with the hypothesis test results, the fit from
\code{proDA()} is returned. Default: \code{FALSE}}

\item{verbose}{boolean that signals if the method prints messages
during the fitting. Default: \code{FALSE}}

\item{groups}{a factor or character vector with that assignes the
columns of \code{X} to different conditions. This parameter is
only applicable for the F-test and must be specified if only a
single matrix is provided.}
}
\value{
If \code{return_fit == FALSE} a data.frame is returned with the content
  that is described in \code{\link{test_diff}}.

  If \code{return_fit == TRUE} a list is returned with two elements:
  \code{fit} with a reference to the object returned from \code{proDA()}
  and a \code{test_result()} with the data.frame returned from
  \code{test_diff()}.
}
\description{
This is a helper function that combines the call of \code{proDA()}
and \code{test_diff()}. If you need more flexibility use those
functions.
}
\details{
The \code{pd_row_t_test} is not actually doing a t-test, but rather
a Wald test. But, as the two are closely related and term t-test is
more widely understood, we choose to use that name.
}
\examples{
  data1 <- matrix(rnorm(10 * 3), nrow=10)
  data2 <- matrix(rnorm(10 * 4), nrow=10)
  data3 <- matrix(rnorm(10 * 2), nrow=10)

  # Comparing two datasets
  pd_row_t_test(data1, data2)

  # Comparing multiple datasets
  pd_row_f_test(data1, data2, data3)

  # Alternative
  data_comb <- cbind(data1, data2, data3)
  pd_row_f_test(data_comb,
     groups = c(rep("A",3), rep("B", 4), rep("C", 2)))

  # t.test, lm, pd_row_t_test, and pd_row_f_test are
  # approximately equivalent on fully observed data
  set.seed(1)
  x <- rnorm(5)
  y <- rnorm(5, mean=0.3)

  t.test(x, y)
  summary(lm(c(x, y) ~ cond,
             data = data.frame(cond = c(rep("x", 5),
                                        rep("y", 5)))))$coefficients[2,]
  pd_row_t_test(matrix(x, nrow=1), matrix(y, nrow=1),
                moderate_location = FALSE,
                moderate_variance = FALSE)
  pd_row_f_test(matrix(x, nrow=1), matrix(y, nrow=1),
                moderate_location = FALSE,
                moderate_variance = FALSE)


}
\seealso{
\code{\link{proDA}} and \code{\link{test_diff}} for more
  flexible versions. The  function was inspired
  by the \code{\link[genefilter]{rowFtests}} function in the genefilter
  package.
}
