% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{dist_approx}
\alias{dist_approx}
\title{Calculate an approximate distance for 'object'}
\usage{
dist_approx(object, ...)
}
\arguments{
\item{object}{the object for which the distance is approximated}

\item{...}{additional arguments used by the concrete implementation}
}
\value{
a list with two elements: `mean` and `sd` both are formally
  of class "dist"
}
\description{
Calculate an approximate distance for 'object'
}
\examples{
  syn_data <- generate_synthetic_data(n_proteins = 10)
  fit <- proDA(syn_data$Y, design = syn_data$groups)
  dist_approx(fit)

}
\seealso{
\code{\link[stats]{dist}} for the base R function and
  \code{\link[=dist_approx_impl]{dist_approx()}} concrete implementation
  for 'proDAFit' objects
}
