% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/completion.R
\name{.DollarNames.proDAFit}
\alias{.DollarNames.proDAFit}
\alias{$,proDAFit-method}
\alias{dollar_methods}
\alias{$<-,proDAFit-method}
\title{Fluent use of accessor methods}
\usage{
\method{.DollarNames}{proDAFit}(x, pattern = "")

\S4method{$}{proDAFit}(x, name)

\S4method{$}{proDAFit}(x, name) <- value
}
\arguments{
\item{x}{an object of class 'proDAFit' produced by \code{proDA()}}

\item{pattern}{the regex pattern that is provided by the IDE}

\item{name}{one of the functions listed above}

\item{value}{\strong{Warning:} modifying the content of a 'proDAFit'
object is not allowed}
}
\value{
whatever the function called \code{name} returns.
}
\description{
The 'proDAFit' object overwrites the dollar function to make it easy
to call functions to access values inside the object. This has the
advantage that it is very easy to discover the relevant methods
but nonetheless have an isolated implementation. Unlike the
\code{`@`} operator which directly accesses the underlying implementation,
the \code{`$`} operator only exposes a limited set of functions
\itemize{
  \item abundances
  \item hyper_parameters
  \item feature_parameters
  \item coefficients
  \item convergence
  \item design
  \item reference_level
  \item result_names
  \item coefficient_variance_matrices
  \item colData
  \item rowData
}
}
\examples{
  syn_data <- generate_synthetic_data(n_proteins = 10)
  fit <- proDA(syn_data$Y, design = syn_data$groups)

  # The two styles are identical
  design(fit)
  fit$design

  # More functions
  fit$abundances



}
\seealso{
\link{accessor_methods} for more documentation on the
  accessor functions.
}
