% Generated by roxygen2 (4.0.1): do not edit by hand
\name{PSMtab2SAM}
\alias{PSMtab2SAM}
\title{Generate SAM files from PSMs.}
\usage{
PSMtab2SAM(passedPSM, XScolumn = "mvh", exon_anno, proteinseq, procodingseq,
    ...)
}
\arguments{
\item{passedPSM}{a data frame of PSMs passed FDR.}

\item{XScolumn}{specify the column which represents the matching score.}

\item{exon_anno}{a dataframe of exon annotations.}

\item{proteinseq}{a dataframe containing  protein ids and protein
sequences.}

\item{procodingseq}{a data frame cotaining coding sequence for each
protein.}

\item{...}{additional arguments}
}
\value{
a dataframe containing
}
\description{
Generate SAM files from confident peptide-spectrum-matches (PSMs).
}
\examples{
load(system.file("extdata/GENCODE", "exon_anno.RData", package="proBAMr"))
load(system.file("extdata/GENCODE", "proseq.RData", package="proBAMr"))
load(system.file("extdata/GENCODE", "procodingseq.RData",
    package="proBAMr"))
options(stringsAsFactors=FALSE)
passedPSM <- read.table(system.file("extdata", "passedPSM.tab",
    package="proBAMr"), sep='\\t', header=TRUE)
SAM <- PSMtab2SAM(passedPSM, XScolumn='mvh', exon, proteinseq,
    procodingseq)
write.table(SAM, file=paste(tempdir(), '/test.sam', sep=''),
            sep='\\t', quote=FALSE, row.names=FALSE, col.names=FALSE)
}
\author{
Xiaojing Wang
}

