#' primirTSS: Search for putative TSSs of miRNA
#'
#' A fast, convenient tool to identify the TSSs of miRNAs
#' by integrating the data of H3K4me3 and Pol II as well as
#' combining the conservation level and sequence feature,
#' provided within both command-line and graphical interfaces,
#' which achieves a better performance than
#' the previous non-cell-specific methods on miRNA TSSs.
#'
#'
#' @section Detail:
#'   See \code{\link{find_tss}} for deailted instruction
#'   to predict TSSs of miRNA;
#'   See \code{\link{run_primirTSSapp}}
#'   to predict TSSs of miRNA using graphical web interface.
#'
#' @section Author(s):
#'
#'   Maintainer: Pumin Li \email{ipumin@@163.com}
#'
#'   Other contributors: Qi Xu \email{xuqi@@vip.qq.com}
#'
#'
#' @seealso
#'   Useful links:
#'   \href{https://academic.oup.com/bioinformatics/article-lookup/doi/10.1093/bioinformatics/btw171}{Xu HUA et al}
#'
#' @docType package
#' @name primirTSS
#'
NULL

