/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.SingletonList;

public class SimpleAlphabet
extends AbstractAlphabet
implements Serializable {
    private String name;
    private Annotation annotation;
    private final Set symbols = new HashSet();
    private final Map ambigMap;
    private final Set ambig = new HashSet();
    private List alphabets;

    public SimpleAlphabet() {
        this(new HashSet(), null);
    }

    public SimpleAlphabet(String string) {
        this(new HashSet(), string);
    }

    public SimpleAlphabet(Set set) {
        this(set, null);
    }

    public SimpleAlphabet(Set set, String string) {
        this.ambigMap = new HashMap();
        this.name = string;
        this.alphabets = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AtomicSymbol atomicSymbol = (AtomicSymbol)iterator.next();
            this.symbols.add(atomicSymbol);
        }
    }

    public void addAmbiguity(Symbol symbol) throws IllegalSymbolException {
        this.validate(symbol);
        if (this.ambig.contains(symbol)) {
            throw new IllegalSymbolException("Can't add " + symbol.getName() + " twice");
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = ((FiniteAlphabet)symbol.getMatches()).iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        this.ambig.add(symbol);
        this.ambigMap.put(hashSet, symbol);
    }

    protected void addSymbolImpl(AtomicSymbol atomicSymbol) throws IllegalSymbolException, ChangeVetoException {
        this.symbols.add(atomicSymbol);
    }

    public Iterator ambiguities() {
        return this.ambig.iterator();
    }

    protected boolean containsImpl(AtomicSymbol atomicSymbol) {
        return this.symbols.contains(atomicSymbol);
    }

    public List getAlphabets() {
        if (this.alphabets == null) {
            this.alphabets = new SingletonList(this);
        }
        return this.alphabets;
    }

    public Symbol getAmbiguity(Set set) throws IllegalSymbolException {
        Symbol symbol = (Symbol)this.ambigMap.get(set);
        if (symbol == null) {
            symbol = super.getAmbiguity(set);
            this.addAmbiguity(symbol);
        }
        return symbol;
    }

    public Annotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new SimpleAnnotation();
        }
        return this.annotation;
    }

    public String getName() {
        return this.name;
    }

    public AtomicSymbol getSymbolImpl(List list) throws IllegalSymbolException {
        AtomicSymbol atomicSymbol = (AtomicSymbol)list.get(0);
        return atomicSymbol;
    }

    public Iterator iterator() {
        return this.symbols.iterator();
    }

    public void removeSymbol(Symbol symbol) throws IllegalSymbolException {
        this.validate(symbol);
        if (symbol instanceof AtomicSymbol) {
            this.symbols.remove(symbol);
        } else {
            FiniteAlphabet finiteAlphabet = (FiniteAlphabet)symbol.getMatches();
            Iterator iterator = finiteAlphabet.iterator();
            while (iterator.hasNext()) {
                Symbol symbol2 = (Symbol)iterator.next();
                this.symbols.remove(symbol2);
            }
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public int size() {
        return this.symbols.size();
    }

    public SymbolList symbols() {
        try {
            return new SimpleSymbolList(this, new ArrayList(this.symbols));
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "There should be no circumstances under which this failed");
        }
    }
}

