/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.HashSet;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeAdapter;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

class LinearAlphabetIndex
extends AbstractChangeable
implements AlphabetIndex {
    private FiniteAlphabet alpha;
    private Symbol[] symbols;
    private ChangeListener indexBuilder;
    private ChangeListener adapter;

    public LinearAlphabetIndex(FiniteAlphabet finiteAlphabet) {
        finiteAlphabet.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
        this.alpha = finiteAlphabet;
        this.symbols = this.buildIndex(finiteAlphabet);
        this.indexBuilder = new IndexRebuilder();
        finiteAlphabet.addChangeListener(this.indexBuilder, Alphabet.SYMBOLS);
        this.adapter = new ChangeAdapter(){

            public void postChange(ChangeEvent changeEvent) {
                LinearAlphabetIndex.this.symbols = (Symbol[])changeEvent.getChange();
            }
        };
        this.addChangeListener(this.adapter, AlphabetIndex.INDEX);
        finiteAlphabet.removeChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    public LinearAlphabetIndex(Symbol[] symbolArray) throws BioException {
        HashSet<Symbol> hashSet = new HashSet<Symbol>();
        Symbol[] symbolArray2 = new Symbol[symbolArray.length];
        int n = 0;
        while (n < symbolArray.length) {
            Symbol symbol;
            symbolArray2[n] = symbol = symbolArray[n];
            hashSet.add(symbol);
            ++n;
        }
        this.alpha = new SimpleAlphabet(hashSet);
        this.alpha.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
        this.symbols = symbolArray2;
    }

    private Symbol[] buildIndex(FiniteAlphabet finiteAlphabet) {
        Symbol[] symbolArray = new Symbol[finiteAlphabet.size()];
        int n = 0;
        Iterator iterator = finiteAlphabet.iterator();
        while (iterator.hasNext()) {
            symbolArray[n++] = (Symbol)iterator.next();
        }
        return symbolArray;
    }

    public FiniteAlphabet getAlphabet() {
        return this.alpha;
    }

    protected ChangeSupport getChangeSupport(ChangeType changeType) {
        return super.getChangeSupport(changeType);
    }

    public int indexForSymbol(Symbol symbol) throws IllegalSymbolException {
        int n = 0;
        while (n < this.symbols.length) {
            if (symbol == this.symbols[n]) {
                return n;
            }
            ++n;
        }
        this.getAlphabet().validate(symbol);
        if (symbol instanceof AtomicSymbol) {
            throw new BioError("Assertion Failure: Symbol " + symbol.getName() + " was not an indexed member of the alphabet " + this.getAlphabet().getName() + " despite being in the alphabet.");
        }
        throw new IllegalSymbolException("Symbol must be atomic to be indexed.");
    }

    public Symbol symbolForIndex(int n) throws IndexOutOfBoundsException {
        try {
            return this.symbols[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IndexOutOfBoundsException("Can't find symbol for index " + n);
        }
    }

    protected class IndexRebuilder
    extends ChangeForwarder {
        public IndexRebuilder() {
            super(LinearAlphabetIndex.this, LinearAlphabetIndex.this.getChangeSupport(AlphabetIndex.INDEX));
        }

        public ChangeEvent generateEvent(ChangeEvent changeEvent) throws ChangeVetoException {
            if (changeEvent.getType() != Alphabet.SYMBOLS) {
                return null;
            }
            return new ChangeEvent(this.getSource(), AlphabetIndex.INDEX, LinearAlphabetIndex.this.buildIndex((FiniteAlphabet)changeEvent.getSource()), LinearAlphabetIndex.this.symbols, changeEvent);
        }
    }
}

