/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import org.biojava.bio.symbol.AbstractRangeLocation;

public class FuzzyLocation
extends AbstractRangeLocation
implements Serializable {
    public static final RangeResolver RESOLVE_INNER = new InnerRangeResolver();
    public static final RangeResolver RESOLVE_OUTER = new OuterRangeResolver();
    public static final RangeResolver RESOLVE_AVERAGE = new AverageRangeResolver();
    private int outerMin;
    private int innerMin;
    private int innerMax;
    private int outerMax;
    private RangeResolver resolver;

    public FuzzyLocation(int n, int n2, int n3, int n4, RangeResolver rangeResolver) {
        this.outerMin = n;
        this.outerMax = n2;
        this.innerMin = n3;
        this.innerMax = n4;
        this.resolver = rangeResolver;
    }

    public int getInnerMax() {
        return this.innerMax;
    }

    public int getInnerMin() {
        return this.innerMin;
    }

    public int getMax() {
        return this.resolver.resolveMax(this);
    }

    public int getMin() {
        return this.resolver.resolveMin(this);
    }

    public int getOuterMax() {
        return this.outerMax;
    }

    public int getOuterMin() {
        return this.outerMin;
    }

    public RangeResolver getResolver() {
        return this.resolver;
    }

    public boolean hasBoundedMax() {
        return this.outerMax != Integer.MAX_VALUE;
    }

    public boolean hasBoundedMin() {
        return this.outerMin != Integer.MIN_VALUE;
    }

    public String toString() {
        return "[" + (this.hasBoundedMin() ? Integer.toString(this.getMin()) : "<" + Integer.toString(this.getMin())) + ", " + (this.hasBoundedMax() ? Integer.toString(this.getMax()) : ">" + Integer.toString(this.getMax())) + "]";
    }

    public static interface RangeResolver {
        public int resolveMax(FuzzyLocation var1);

        public int resolveMin(FuzzyLocation var1);
    }

    private static class InnerRangeResolver
    implements RangeResolver {
        InnerRangeResolver() {
        }

        public int resolveMax(FuzzyLocation fuzzyLocation) {
            return fuzzyLocation.getInnerMax();
        }

        public int resolveMin(FuzzyLocation fuzzyLocation) {
            return fuzzyLocation.getInnerMin();
        }
    }

    private static class OuterRangeResolver
    implements RangeResolver {
        OuterRangeResolver() {
        }

        public int resolveMax(FuzzyLocation fuzzyLocation) {
            if (fuzzyLocation.hasBoundedMax()) {
                return fuzzyLocation.getOuterMax();
            }
            return fuzzyLocation.getInnerMax();
        }

        public int resolveMin(FuzzyLocation fuzzyLocation) {
            if (fuzzyLocation.hasBoundedMin()) {
                return fuzzyLocation.getOuterMin();
            }
            return fuzzyLocation.getInnerMin();
        }
    }

    private static class AverageRangeResolver
    implements RangeResolver {
        AverageRangeResolver() {
        }

        public int resolveMax(FuzzyLocation fuzzyLocation) {
            if (fuzzyLocation.hasBoundedMax()) {
                return fuzzyLocation.getOuterMax() + fuzzyLocation.getInnerMax() / 2;
            }
            return fuzzyLocation.getInnerMax();
        }

        public int resolveMin(FuzzyLocation fuzzyLocation) {
            if (fuzzyLocation.hasBoundedMin()) {
                return fuzzyLocation.getOuterMin() + fuzzyLocation.getInnerMin() / 2;
            }
            return fuzzyLocation.getInnerMin();
        }
    }
}

