/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;

public class SeqIOEventEmitter {
    private SeqIOEventEmitter() {
    }

    public static void getSeqIOEvents(Sequence sequence, SeqIOListener seqIOListener) {
        try {
            List list;
            seqIOListener.startSequence();
            seqIOListener.setName(sequence.getName());
            seqIOListener.setURI(sequence.getURN());
            Annotation annotation = sequence.getAnnotation();
            Iterator iterator = annotation.keys().iterator();
            while (iterator.hasNext()) {
                list = iterator.next();
                seqIOListener.addSequenceProperty(list, annotation.getProperty(list));
            }
            list = SeqIOEventEmitter.getSubFeatures(sequence);
            Collections.sort(list, Feature.byLocationOrder);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Feature.Template template = ((Feature)iterator2.next()).makeTemplate();
                seqIOListener.startFeature(template);
                Iterator iterator3 = template.annotation.keys().iterator();
                while (iterator3.hasNext()) {
                    Object e = iterator3.next();
                    seqIOListener.addFeatureProperty(e, template.annotation.getProperty(e));
                }
                seqIOListener.endFeature();
            }
            seqIOListener.addSymbols(sequence.getAlphabet(), sequence.toList().toArray(new Symbol[0]), 1, sequence.length());
            seqIOListener.endSequence();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (IllegalAlphabetException illegalAlphabetException) {
            illegalAlphabetException.printStackTrace();
        }
    }

    private static List getSubFeatures(FeatureHolder featureHolder) {
        ArrayList<FeatureHolder> arrayList = new ArrayList<FeatureHolder>();
        Iterator iterator = featureHolder.features();
        while (iterator.hasNext()) {
            FeatureHolder featureHolder2 = (FeatureHolder)iterator.next();
            arrayList.addAll(SeqIOEventEmitter.getSubFeatures(featureHolder2));
            arrayList.add(featureHolder2);
        }
        return arrayList;
    }
}

