/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.OptimizableFilter;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;

public interface FeatureFilter
extends Serializable {
    public static final FeatureFilter all = new AcceptAllFilter();
    public static final FeatureFilter none = new AcceptNoneFilter();

    public boolean accept(Feature var1);

    public static final class AcceptAllFilter
    implements OptimizableFilter {
        public boolean accept(Feature feature) {
            return true;
        }

        public boolean equals(Object object) {
            return object instanceof AcceptAllFilter;
        }

        public boolean isDisjoint(FeatureFilter featureFilter) {
            return featureFilter instanceof AcceptNoneFilter;
        }

        public boolean isProperSubset(FeatureFilter featureFilter) {
            return featureFilter.equals(this);
        }
    }

    public static final class AcceptNoneFilter
    implements OptimizableFilter {
        public boolean accept(Feature feature) {
            return false;
        }

        public boolean equals(Object object) {
            return object instanceof AcceptNoneFilter;
        }

        public boolean isDisjoint(FeatureFilter featureFilter) {
            return true;
        }

        public boolean isProperSubset(FeatureFilter featureFilter) {
            return true;
        }
    }

    public static final class ByType
    implements OptimizableFilter {
        private String type;

        public ByType(String string) {
            this.type = string;
        }

        public boolean accept(Feature feature) {
            return this.type.equals(feature.getType());
        }

        public boolean equals(Object object) {
            return object instanceof ByType && ((ByType)object).getType() == this.getType();
        }

        public String getType() {
            return this.type;
        }

        public boolean isDisjoint(FeatureFilter featureFilter) {
            return featureFilter instanceof AcceptNoneFilter || featureFilter instanceof ByType && !this.getType().equals(((ByType)featureFilter).getType());
        }

        public boolean isProperSubset(FeatureFilter featureFilter) {
            return this.equals(featureFilter) || featureFilter instanceof AcceptAllFilter;
        }
    }

    public static final class BySource
    implements OptimizableFilter {
        private String source;

        public BySource(String string) {
            this.source = string;
        }

        public boolean accept(Feature feature) {
            return this.source.equals(feature.getSource());
        }

        public boolean equals(Object object) {
            return object instanceof BySource && ((BySource)object).getSource() == this.getSource();
        }

        public String getSource() {
            return this.source;
        }

        public boolean isDisjoint(FeatureFilter featureFilter) {
            return featureFilter instanceof AcceptNoneFilter || featureFilter instanceof BySource && !this.getSource().equals(((BySource)featureFilter).getSource());
        }

        public boolean isProperSubset(FeatureFilter featureFilter) {
            return this.equals(featureFilter) || featureFilter instanceof AcceptAllFilter;
        }
    }

    public static final class ByClass
    implements OptimizableFilter {
        private Class clazz;

        public ByClass(Class clazz) {
            this.clazz = clazz;
        }

        public boolean accept(Feature feature) {
            return this.clazz.isInstance(feature);
        }

        public boolean equals(Object object) {
            return object instanceof ByClass && ((ByClass)object).getTestClass() == this.getTestClass();
        }

        public Class getTestClass() {
            return this.clazz;
        }

        public boolean isDisjoint(FeatureFilter featureFilter) {
            if (featureFilter instanceof ByClass) {
                Class<?> clazz = ((ByClass)featureFilter).getClass();
                return !clazz.isAssignableFrom(this.getClass()) && !this.getClass().isAssignableFrom(clazz);
            }
            return featureFilter instanceof AcceptNoneFilter;
        }

        public boolean isProperSubset(FeatureFilter featureFilter) {
            if (featureFilter instanceof ByClass) {
                Class clazz = ((ByClass)featureFilter).getTestClass();
                return clazz.isAssignableFrom(this.getClass());
            }
            return featureFilter instanceof AcceptAllFilter;
        }
    }

    public static final class ContainedByLocation
    implements OptimizableFilter {
        private Location loc;

        public ContainedByLocation(Location location) {
            this.loc = location;
        }

        public boolean accept(Feature feature) {
            return this.loc.contains(feature.getLocation());
        }

        public boolean equals(Object object) {
            return object instanceof ContainedByLocation && ((ContainedByLocation)object).getLocation() == this.getLocation();
        }

        public Location getLocation() {
            return this.loc;
        }

        public boolean isDisjoint(FeatureFilter featureFilter) {
            if (featureFilter instanceof ContainedByLocation) {
                Location location = ((ContainedByLocation)featureFilter).getLocation();
                return this.getLocation().overlaps(location) ^ true;
            }
            if (featureFilter instanceof OverlapsLocation) {
                Location location = ((OverlapsLocation)featureFilter).getLocation();
                return location.overlaps(this.getLocation()) ^ true;
            }
            return featureFilter instanceof AcceptNoneFilter;
        }

        public boolean isProperSubset(FeatureFilter featureFilter) {
            if (featureFilter instanceof ContainedByLocation) {
                Location location = ((ContainedByLocation)featureFilter).getLocation();
                return location.contains(this.getLocation());
            }
            if (featureFilter instanceof OverlapsLocation) {
                Location location = ((OverlapsLocation)featureFilter).getLocation();
                return location.contains(this.getLocation());
            }
            return featureFilter instanceof AcceptAllFilter;
        }
    }

    public static final class OverlapsLocation
    implements OptimizableFilter {
        private Location loc;

        public OverlapsLocation(Location location) {
            this.loc = location;
        }

        public boolean accept(Feature feature) {
            return this.loc.overlaps(feature.getLocation());
        }

        public boolean equals(Object object) {
            return object instanceof OverlapsLocation && ((OverlapsLocation)object).getLocation() == this.getLocation();
        }

        public Location getLocation() {
            return this.loc;
        }

        public boolean isDisjoint(FeatureFilter featureFilter) {
            if (featureFilter instanceof ContainedByLocation) {
                Location location = ((ContainedByLocation)featureFilter).getLocation();
                return this.getLocation().overlaps(location) ^ true;
            }
            return featureFilter instanceof AcceptNoneFilter;
        }

        public boolean isProperSubset(FeatureFilter featureFilter) {
            if (featureFilter instanceof OverlapsLocation) {
                Location location = ((OverlapsLocation)featureFilter).getLocation();
                return location.contains(this.getLocation());
            }
            return featureFilter instanceof AcceptAllFilter;
        }
    }

    public static final class Not
    implements OptimizableFilter {
        FeatureFilter child;

        public Not(FeatureFilter featureFilter) {
            this.child = featureFilter;
        }

        public boolean accept(Feature feature) {
            return this.child.accept(feature) ^ true;
        }

        public boolean equals(Object object) {
            return object instanceof Not && ((Not)object).getChild() == this.getChild();
        }

        public FeatureFilter getChild() {
            return this.child;
        }

        public boolean isDisjoint(FeatureFilter featureFilter) {
            return FilterUtils.areProperSubset(featureFilter, this.getChild());
        }

        public boolean isProperSubset(FeatureFilter featureFilter) {
            if (featureFilter instanceof Not) {
                FeatureFilter featureFilter2 = ((Not)featureFilter).getChild();
                FilterUtils.areProperSubset(featureFilter2, this.getChild());
            }
            return featureFilter instanceof AcceptAllFilter;
        }
    }

    public static final class And
    implements OptimizableFilter {
        FeatureFilter c1;
        FeatureFilter c2;

        public And(FeatureFilter featureFilter, FeatureFilter featureFilter2) {
            this.c1 = featureFilter;
            this.c2 = featureFilter2;
        }

        public boolean accept(Feature feature) {
            return this.c1.accept(feature) && this.c2.accept(feature);
        }

        public boolean equals(Object object) {
            return object instanceof And && ((And)object).getChild1() == this.getChild1() && ((And)object).getChild2() == this.getChild2();
        }

        public FeatureFilter getChild1() {
            return this.c1;
        }

        public FeatureFilter getChild2() {
            return this.c2;
        }

        public boolean isDisjoint(FeatureFilter featureFilter) {
            return featureFilter instanceof AcceptNoneFilter || FilterUtils.areDisjoint(this.getChild1(), featureFilter) || FilterUtils.areDisjoint(this.getChild2(), featureFilter);
        }

        public boolean isProperSubset(FeatureFilter featureFilter) {
            return FilterUtils.areProperSubset(this.getChild1(), featureFilter) || FilterUtils.areProperSubset(this.getChild2(), featureFilter);
        }
    }

    public static final class AndNot
    implements FeatureFilter {
        FeatureFilter c1;
        FeatureFilter c2;

        public AndNot(FeatureFilter featureFilter, FeatureFilter featureFilter2) {
            this.c1 = featureFilter;
            this.c2 = featureFilter2;
        }

        public boolean accept(Feature feature) {
            return this.c1.accept(feature) && !this.c2.accept(feature);
        }

        public boolean equals(Object object) {
            return object instanceof AndNot && ((And)object).getChild1() == this.getChild1() && ((And)object).getChild2() == this.getChild2();
        }

        public FeatureFilter getChild1() {
            return this.c1;
        }

        public FeatureFilter getChild2() {
            return this.c2;
        }
    }

    public static final class Or
    implements OptimizableFilter {
        FeatureFilter c1;
        FeatureFilter c2;

        public Or(FeatureFilter featureFilter, FeatureFilter featureFilter2) {
            this.c1 = featureFilter;
            this.c2 = featureFilter2;
        }

        public boolean accept(Feature feature) {
            return this.c1.accept(feature) || this.c2.accept(feature);
        }

        public boolean equals(Object object) {
            return object instanceof Or && ((Or)object).getChild1() == this.getChild1() && ((Or)object).getChild2() == this.getChild2();
        }

        public FeatureFilter getChild1() {
            return this.c1;
        }

        public FeatureFilter getChild2() {
            return this.c2;
        }

        public boolean isDisjoint(FeatureFilter featureFilter) {
            return featureFilter instanceof AcceptNoneFilter || FilterUtils.areDisjoint(this.getChild1(), featureFilter) && FilterUtils.areDisjoint(this.getChild2(), featureFilter);
        }

        public boolean isProperSubset(FeatureFilter featureFilter) {
            return FilterUtils.areProperSubset(this.getChild1(), featureFilter) && FilterUtils.areProperSubset(this.getChild2(), featureFilter);
        }
    }

    public static final class ByAnnotation
    implements OptimizableFilter {
        private Object key;
        private Object value;

        public ByAnnotation(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public boolean accept(Feature feature) {
            Annotation annotation = feature.getAnnotation();
            try {
                Object object = annotation.getProperty(this.key);
                if (object == null) {
                    return this.value == null;
                }
                return object.equals(this.value);
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }

        public boolean equals(Object object) {
            return object instanceof ByAnnotation && ((ByAnnotation)object).getKey() == this.getKey() && ((ByAnnotation)object).getValue() == this.getValue();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isDisjoint(FeatureFilter featureFilter) {
            return featureFilter instanceof AcceptNoneFilter || featureFilter instanceof ByAnnotation && (!this.getKey().equals(((ByAnnotation)featureFilter).getKey()) || !this.getValue().equals(((ByAnnotation)featureFilter).getValue()));
        }

        public boolean isProperSubset(FeatureFilter featureFilter) {
            return this.equals(featureFilter);
        }
    }

    public static final class HasAnnotation
    implements FeatureFilter {
        private Object key;

        public HasAnnotation(Object object) {
            this.key = object;
        }

        public boolean accept(Feature feature) {
            Annotation annotation = feature.getAnnotation();
            try {
                Object object = annotation.getProperty(this.key);
                return true;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }

        public boolean equals(Object object) {
            return object instanceof HasAnnotation && ((HasAnnotation)object).getKey() == this.getKey();
        }

        public Object getKey() {
            return this.key;
        }

        public boolean isDisjoint(FeatureFilter featureFilter) {
            return featureFilter instanceof AcceptNoneFilter || featureFilter instanceof HasAnnotation && !this.getKey().equals(((HasAnnotation)featureFilter).getKey());
        }

        public boolean isProperSubset(FeatureFilter featureFilter) {
            return this.equals(featureFilter);
        }
    }

    public static final class StrandFilter
    implements OptimizableFilter {
        private StrandedFeature.Strand strand;

        public StrandFilter(StrandedFeature.Strand strand) {
            this.strand = strand;
        }

        public boolean accept(Feature feature) {
            if (feature instanceof StrandedFeature) {
                StrandedFeature strandedFeature = (StrandedFeature)feature;
                return strandedFeature.getStrand() == this.strand;
            }
            return this.strand == StrandedFeature.UNKNOWN;
        }

        public boolean equals(Object object) {
            return object instanceof StrandFilter && ((StrandFilter)object).getStrand() == this.getStrand();
        }

        public StrandedFeature.Strand getStrand() {
            return this.strand;
        }

        public boolean isDisjoint(FeatureFilter featureFilter) {
            return featureFilter instanceof AcceptNoneFilter || featureFilter instanceof StrandFilter && ((StrandFilter)featureFilter).getStrand() == this.getStrand();
        }

        public boolean isProperSubset(FeatureFilter featureFilter) {
            return this.equals(featureFilter);
        }
    }
}

