/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Line2D;
import java.util.List;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.symbol.RangeLocation;

public class RulerRenderer
implements SequenceRenderer {
    private double depth = 25.0;

    public double getDepth(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return this.depth + 1.0;
    }

    public double getMinimumLeader(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return 0.0;
    }

    public double getMinimumTrailer(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        String string = String.valueOf(sequenceRenderContext.getSequence().length());
        Font font = sequenceRenderContext.getFont();
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
        return glyphVector.getVisualBounds().getWidth();
    }

    public void paint(Graphics2D graphics2D, SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        int n;
        int n2 = rangeLocation.getMin();
        int n3 = rangeLocation.getMax();
        double d = sequenceRenderContext.sequenceToGraphics(n2);
        double d2 = sequenceRenderContext.sequenceToGraphics(n3);
        double d3 = sequenceRenderContext.getScale();
        double d4 = d3 * 0.5;
        Line2D.Double double_ = sequenceRenderContext.getDirection() == 0 ? new Line2D.Double(d + d4, 0.0, d2 + d4, 0.0) : new Line2D.Double(0.0, d + d4, 0.0, d2 + d4);
        graphics2D.draw(double_);
        int n4 = sequenceRenderContext.graphicsToSequence(40.0);
        double d5 = Math.log(10.0);
        int n5 = (int)Math.exp(Math.ceil(Math.log(n4) / d5) * d5);
        int n6 = n = n2 + (n5 - n2) % n5;
        while (n6 <= n3) {
            double d6 = sequenceRenderContext.sequenceToGraphics(n6);
            if (sequenceRenderContext.getDirection() == 0) {
                ((Line2D)double_).setLine(d6 + d4, 0.0, d6 + d4, 5.0);
                graphics2D.drawString(String.valueOf(n6), (float)(d6 + d4), 20.0f);
            } else {
                ((Line2D)double_).setLine(0.0, d6 + d4, 5.0, d6 + d4);
            }
            graphics2D.draw(double_);
            n6 += n5;
        }
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext sequenceRenderContext, MouseEvent mouseEvent, List list, RangeLocation rangeLocation) {
        list.add(this);
        int n = sequenceRenderContext.graphicsToSequence(mouseEvent.getPoint());
        return new SequenceViewerEvent(this, null, n, mouseEvent, list);
    }
}

