/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class DNAStyle
implements SymbolStyle {
    private Map outlinePaint = new HashMap();
    private Map fillPaint = new HashMap();

    public DNAStyle() {
        try {
            this.setOutlinePaint(DNATools.t(), Color.black);
            this.setFillPaint(DNATools.t(), Color.red);
            this.setOutlinePaint(DNATools.a(), Color.black);
            this.setFillPaint(DNATools.a(), Color.green);
            this.setOutlinePaint(DNATools.g(), Color.black);
            this.setFillPaint(DNATools.g(), Color.blue);
            this.setOutlinePaint(DNATools.c(), Color.black);
            this.setFillPaint(DNATools.c(), Color.yellow);
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "DNA symbols dissapeared from DNA alphabet");
        }
    }

    public Paint fillPaint(Symbol symbol) throws IllegalSymbolException {
        DNATools.getDNA().validate(symbol);
        return (Paint)this.fillPaint.get(symbol);
    }

    public Paint outlinePaint(Symbol symbol) throws IllegalSymbolException {
        DNATools.getDNA().validate(symbol);
        return (Paint)this.outlinePaint.get(symbol);
    }

    public void setFillPaint(Symbol symbol, Paint paint) throws IllegalSymbolException {
        DNATools.getDNA().validate(symbol);
        this.fillPaint.put(symbol, paint);
    }

    public void setOutlinePaint(Symbol symbol, Paint paint) throws IllegalSymbolException {
        DNATools.getDNA().validate(symbol);
        this.outlinePaint.put(symbol, paint);
    }
}

