/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainer;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;

public final class SimpleDistributionTrainer
implements DistributionTrainer,
Serializable {
    private final Distribution dis;
    private final Map c = new HashMap();

    public SimpleDistributionTrainer(Distribution distribution) throws IllegalAlphabetException {
        Alphabet alphabet = distribution.getAlphabet();
        if (!(alphabet instanceof FiniteAlphabet)) {
            throw new IllegalAlphabetException("Can't create a SimpleDistributionTrainer for non-finite alphabet " + alphabet.getName() + " of type " + alphabet.getClass());
        }
        this.dis = distribution;
        this.clearCounts();
    }

    public void addCount(DistributionTrainerContext distributionTrainerContext, AtomicSymbol atomicSymbol, double d) throws IllegalSymbolException {
        Double d2 = (Double)this.c.get(atomicSymbol);
        if (d2 == null) {
            throw new IllegalSymbolException("Symbol " + atomicSymbol.getName() + " not found in " + this.dis.getAlphabet().getName());
        }
        if (d < 0.0) {
            throw new Error("Can't add a negative count for " + atomicSymbol.getName() + " of " + d);
        }
        this.c.put(atomicSymbol, new Double(d2 + d));
    }

    public void clearCounts() {
        Iterator iterator = ((FiniteAlphabet)this.dis.getAlphabet()).iterator();
        while (iterator.hasNext()) {
            this.c.put(iterator.next(), new Double(0.0));
        }
    }

    public void train(double d) throws ChangeVetoException {
        Distribution distribution = this.dis.getNullModel();
        double d2 = 0.0;
        try {
            Object object;
            Object object2;
            Iterator iterator = ((FiniteAlphabet)this.dis.getAlphabet()).iterator();
            while (iterator.hasNext()) {
                object2 = (Symbol)iterator.next();
                object = (Double)this.c.get(object2);
                d2 += (Double)object + distribution.getWeight((Symbol)object2) * d;
            }
            object2 = ((FiniteAlphabet)this.dis.getAlphabet()).iterator();
            while (object2.hasNext()) {
                object = (Symbol)object2.next();
                Double d3 = (Double)this.c.get(object);
                this.dis.setWeight((Symbol)object, (d3 + distribution.getWeight((Symbol)object) * d) / d2);
            }
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError("The alphabet for this distribution is not self-consistent");
        }
    }
}

