/*
 * Decompiled with CFR 0.152.
 */
package org.acedb;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.acedb.AceException;
import org.acedb.AceNode;
import org.acedb.AceSet;
import org.acedb.AceURL;

public class AceUtils {
    public static String decode(String string) throws AceException {
        if (string.indexOf("-") != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == '-') {
                    if (stringBuffer.charAt(n + 1) == '-') {
                        stringBuffer.delete(n, n + 1);
                    } else {
                        stringBuffer.setCharAt(n, '%');
                    }
                }
                ++n;
            }
            string = stringBuffer.toString();
        }
        try {
            string = URLDecoder.decode(string);
        }
        catch (Exception exception) {
            throw new AceException(exception, "Couldn't decode " + string);
        }
        return string;
    }

    public static String encode(String string) {
        if ((string = URLEncoder.encode(string)).indexOf("%") != -1 || string.indexOf("-") != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = stringBuffer.length() - 1;
            while (n >= 0) {
                if (stringBuffer.charAt(n) == '%') {
                    stringBuffer.setCharAt(n, '-');
                } else if (stringBuffer.charAt(n) == '-') {
                    stringBuffer.insert(n, '-');
                }
                --n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static AceNode pick(AceSet aceSet) throws AceException {
        if (aceSet.size() != 1) {
            StringBuffer stringBuffer = new StringBuffer("Set must have one member to be pickable: size=" + aceSet.size());
            if (aceSet instanceof AceNode) {
                AceNode aceNode = (AceNode)aceSet;
                stringBuffer.append(" " + aceNode.getName());
                if (aceNode.size() > 0) {
                    stringBuffer.append("{");
                    Iterator iterator = aceNode.nameIterator();
                    stringBuffer.append(iterator.next());
                    while (iterator.hasNext()) {
                        stringBuffer.append("," + iterator.next());
                    }
                    stringBuffer.append("}");
                }
            }
            throw new AceException(stringBuffer.toString());
        }
        Iterator iterator = aceSet.iterator();
        return (AceNode)iterator.next();
    }

    public static AceSet retrieve(AceSet aceSet, String string) throws AceException {
        List list = AceUtils.toList(string);
        return AceUtils.retrieve(aceSet, list);
    }

    public static AceSet retrieve(AceSet aceSet, List list) throws AceException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if ((aceSet = aceSet.retrieve(string)) != null) continue;
            return null;
        }
        return aceSet;
    }

    public static AceURL rootURL(AceURL aceURL) {
        String string = aceURL.getProtocol();
        String string2 = aceURL.getUserInfo();
        String string3 = aceURL.getAuthority();
        String string4 = aceURL.getHost();
        int n = aceURL.getPort();
        return new AceURL(string, string4, n, null, null, null, string2, string3);
    }

    public static List toList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }
}

