/*
 * Decompiled with CFR 0.152.
 */
package edu.oswego.cs.dl.util.concurrent;

import edu.oswego.cs.dl.util.concurrent.FJTaskRunner;
import edu.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;

public abstract class FJTask
implements Runnable {
    private volatile boolean done;

    public void cancel() {
        this.setDone();
    }

    public static void coInvoke(FJTask[] fJTaskArray) {
        FJTask.getFJTaskRunner().coInvoke(fJTaskArray);
    }

    public static void coInvoke(FJTask fJTask, FJTask fJTask2) {
        FJTask.getFJTaskRunner().coInvoke(fJTask, fJTask2);
    }

    public void fork() {
        FJTask.getFJTaskRunner().push(this);
    }

    public static FJTaskRunner getFJTaskRunner() {
        return (FJTaskRunner)Thread.currentThread();
    }

    public static FJTaskRunnerGroup getFJTaskRunnerGroup() {
        return FJTask.getFJTaskRunner().getGroup();
    }

    public static void invoke(FJTask fJTask) {
        if (!fJTask.isDone()) {
            fJTask.run();
            fJTask.setDone();
        }
    }

    public final boolean isDone() {
        return this.done;
    }

    public void join() {
        FJTask.getFJTaskRunner().taskJoin(this);
    }

    public static FJTask par(FJTask[] fJTaskArray) {
        return new Par(fJTaskArray);
    }

    public static FJTask par(FJTask fJTask, FJTask fJTask2) {
        return new Par2(fJTask, fJTask2);
    }

    public void reset() {
        this.done = false;
    }

    public static FJTask seq(FJTask[] fJTaskArray) {
        return new Seq(fJTaskArray);
    }

    public static FJTask seq(FJTask fJTask, FJTask fJTask2) {
        return new Seq2(fJTask, fJTask2);
    }

    protected final void setDone() {
        this.done = true;
    }

    public void start() {
        FJTask.getFJTaskRunnerGroup().executeTask(this);
    }

    public static void yield() {
        FJTask.getFJTaskRunner().taskYield();
    }

    public abstract void run();

    public static class Par2
    extends FJTask {
        protected final FJTask fst;
        protected final FJTask snd;

        public Par2(FJTask fJTask, FJTask fJTask2) {
            this.fst = fJTask;
            this.snd = fJTask2;
        }

        public void run() {
            FJTask.coInvoke(this.fst, this.snd);
        }
    }

    public static class Seq2
    extends FJTask {
        protected final FJTask fst;
        protected final FJTask snd;

        public Seq2(FJTask fJTask, FJTask fJTask2) {
            this.fst = fJTask;
            this.snd = fJTask2;
        }

        public void run() {
            FJTask.invoke(this.fst);
            FJTask.invoke(this.snd);
        }
    }

    public static class Par
    extends FJTask {
        protected final FJTask[] tasks;

        public Par(FJTask[] fJTaskArray) {
            this.tasks = fJTaskArray;
        }

        public Par(FJTask fJTask, FJTask fJTask2) {
            this.tasks = new FJTask[]{fJTask, fJTask2};
        }

        public void run() {
            FJTask.coInvoke(this.tasks);
        }
    }

    public static class Seq
    extends FJTask {
        protected final FJTask[] tasks;

        public Seq(FJTask[] fJTaskArray) {
            this.tasks = fJTaskArray;
        }

        public Seq(FJTask fJTask, FJTask fJTask2) {
            this.tasks = new FJTask[]{fJTask, fJTask2};
        }

        public void run() {
            int n = 0;
            while (n < this.tasks.length) {
                FJTask.invoke(this.tasks[n]);
                ++n;
            }
        }
    }

    public static class Wrap
    extends FJTask {
        protected final Runnable runnable;

        public Wrap(Runnable runnable) {
            this.runnable = runnable;
        }

        public void run() {
            this.runnable.run();
        }
    }
}

