% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedToGRangesList.R
\name{bedToGRangesList}
\alias{bedToGRangesList}
\title{Function to create a GRangesList object from functional genomic annotation
data in the form of BED files}
\usage{
bedToGRangesList(
  filepath,
  bedList = NULL,
  bedNames = NULL,
  pattern = "*.bed",
  signal = NULL
)
}
\arguments{
\item{filepath}{Character describing the path to the folder containing the
BED files of functional genomic annotations. This is ignored if bedList is
specified.}

\item{bedList}{A list object containing the bed data as data frames to be
converted into a GRangesList. The data frames must include at least
chromosome, start, and end coordinates as the first 3 columns. Default is
NULL.}

\item{bedNames}{A character vector to provide names to the GRangesList,
should be in the order of bedList. Default is NULL.}

\item{pattern}{Character describing the pattern of the files for the
functional genomic annotations. Default is "*.bed".}

\item{signal}{The column number in the BED files that denotes coverage 
strength. Must be the same for all files. Default is NULL indicating to no 
coverage value is to be used.}
}
\value{
A \code{GRangesList} object where each entry is a \code{GRanges}
object specific to each BED file in the path provided
}
\description{
Function to create a GRangesList object from functional genomic annotation
data in the form of BED files
}
\examples{
#set path
path <- system.file("extdata", package = "preciseTAD")
#contains 2 BED files representing YY1 and NFYA
#transcription factor binding sites for GM12878
tfbsList <- bedToGRangesList(filepath = path, bedList=NULL, bedNames=NULL,
pattern = "*.bed", signal=NULL)
}
