# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Identify potential quadruplex forming sequences.
#'
#' Function for identification of all potential intramolecular quadruplex
#' patterns (PQS) in DNA or RNA sequence.
#' 
#' Use \code{\link{elementMetadata}} function to get extra PQS features
#' like number of tetrads (nt), bulges (nb), mismatches (nm) or loop lengths
#' (ll1, ll2, ll3).
#'
#' @param subject DNAString or RNAString object.
#' @param strand Strand specification. Allowed values are "+", "-" or "*",
#'   where the last one represents both strands. Implicitly, the input
#'   DNAString object is assumed to encode the "+" strand.
#' @param overlapping If true, than all overlapping PQS will be reported.
#' @param max_len Maximal lenth of PQS.
#' @param min_score Minimal PQS score. The default value 52 shows the best
#' balanced accuracy on G4 sequencing data provided by Chambers et al. 2015.
#' @param run_min_len Minimal length of quadruplex run.
#' @param run_max_len Maximal length of quadruplex run.
#' @param loop_min_len Minimal length of quadruplex loop. Unless the default scoring
#' system is disabled, at most one loop can have zero length.
#' @param loop_max_len Maxmimal length of quadruplex loop.
#' @param max_bulges Maximal number of runs with bulge.
#' @param max_mismatches Maximal number of runs with mismatch.
#' @param max_defects Maximum number of defects in total (\code{max_bulges +
#'   max_mismatches}).
#' @param tetrad_bonus Score bonus for one complete G tetrade.
#' @param mismatch_penalty Penalization for a mismatch in tetrad.
#' @param bulge_penalty Penalization for a bulge in quadruplex run.
#' @param bulge_len_factor Penalization factor for a bulge length.
#' @param bulge_len_exponent Exponent of bulge length.
#' @param loop_mean_factor Penalization factor of loop length mean.
#' @param loop_mean_exponent Exponent of loop length mean.
#' @param run_re Regular expression specifying one run of quadruplex.
#' @param custom_scoring_fn Custom quadruplex scoring function. It takes the
#'   following 10 arguments: \code{subject} - Input DNAString or RNAString object,
#'   \code{score} - implicit PQS score, \code{start} - PQS start position,
#'   \code{width} - PQS width, \code{loop_1} - start pos. of loop #1,
#'   \code{run_2} - start pos. of run #2, \code{loop_2} - start pos. of loop
#'   #2, \code{run_3} - start pos. of run #3, \code{loop_3} - start pos. of
#'   loop #3, \code{run_4} - start pos. of run #4. Return value of the function
#'   has to be new score represented as a single integer value. Please note
#'   that if \code{use_default_scoring} is enabled, the custom scoring function
#'   is evaluated AFTER the default scoring system but ONLY IF the default
#'   scoring system resulted in non-zero score (for performance reasons). On
#'   the other hand, when \code{use_default_scoring} is disabled, custom
#'   scoring function is evaluated on every PQS.
#' @param use_default_scoring Enables default internal scoring system. This
#'   option is particularly useful in case you intend to radically change the
#'   default behavior and specify your own scoring function. By disabling the
#'   default scoring you will get a full control above the underlying detection
#'   algorithm.
#' @param deep Perform deep search. With this option enabled,
#'   \code{\link{maxScores}} and \code{\link{density}}
#'   vectors are computed. Deep search is much more computationaly demanding.
#' @param verbose Enables detailed output. Turn it on if you want to see all
#'   possible PQS found at each positions and not just the best one. It is
#'   highly recommended to use this option for debugging custom quadruplex
#'   scoring function. Each PQS is reported on separate row in the following
#'   format: \code{start cnt pqs_sequence score}, where \code{start} is the PQS
#'   starting position, \code{pqs_sequence} shows the PQS sequence structure
#'   with each run surrounded by square brackets and \code{score} is the score
#'   assigned to the particular PQS by all applied scoring functions.
#' @return \code{\link{PQSViews}} object
#'
#' @examples
#' pv <- pqsfinder(DNAString("CCCCCCGGGTGGGTGGGTGGGTAAAA"))
#' pv
#' elementMetadata(pv)
#'
pqsfinder <- function(subject, strand = "*", overlapping = FALSE, max_len = 50L, min_score = 47L, run_min_len = 2L, run_max_len = 11L, loop_min_len = 0L, loop_max_len = 30L, max_bulges = 3L, max_mismatches = 3L, max_defects = 3L, tetrad_bonus = 40L, mismatch_penalty = 28L, bulge_penalty = 20L, bulge_len_factor = 0.2, bulge_len_exponent = 1, loop_mean_factor = 6.6, loop_mean_exponent = 0.8, run_re = "G{1,10}.{0,9}G{1,10}", custom_scoring_fn = NULL, use_default_scoring = TRUE, deep = FALSE, verbose = FALSE) {
    .Call('_pqsfinder_pqsfinder', PACKAGE = 'pqsfinder', subject, strand, overlapping, max_len, min_score, run_min_len, run_max_len, loop_min_len, loop_max_len, max_bulges, max_mismatches, max_defects, tetrad_bonus, mismatch_penalty, bulge_penalty, bulge_len_factor, bulge_len_exponent, loop_mean_factor, loop_mean_exponent, run_re, custom_scoring_fn, use_default_scoring, deep, verbose)
}

