% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{mockData}
\alias{mockData}
\title{Generate mock multidimensional data}
\usage{
mockData(
  Ns = c(25, 15),
  classDiff = 2,
  Sds = 1,
  ndims = 2,
  spread = c(1, 2),
  rndFn = rnorm
)
}
\arguments{
\item{Ns}{A vector of more than one positive integers specifying the number
of elements of each class.}

\item{classDiff}{The distances between the classes. If there are more than 2
classes, this can be a \code{dist} object or a symmetric matrix of
\code{length(Ns)-1}columns/rows where the lower triangle indicates the desired
distances between classes.}

\item{Sds}{The standard deviation. Can either be a fixed value, a value per
class, or a matrix of values for each class (rows) and dimension (column).}

\item{ndims}{The number of dimensions to generate (default 2).}

\item{spread}{The spread of the points. Can either be a fixed value, a value
per class, or a matrix of values for each class (rows) and dimension (col).}

\item{rndFn}{The random function, by default \code{rnorm}, but should also work
for \code{rlnorm} and similar.}
}
\value{
A data.frame with coordinates and a \code{class} column.
}
\description{
Generates mock multidimensional data of a given number of classes of points,
for testing.
}
\examples{
d <- mockData()
}
