% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpatialInternalMetrics.R
\name{getSpatialGlobalInternalMetrics}
\alias{getSpatialGlobalInternalMetrics}
\title{Compute dataset-level internal evaluation metrics for spatially-resolved data}
\usage{
getSpatialGlobalInternalMetrics(
  labels,
  location,
  k = 6,
  metrics = c("PAS", "ELSA", "CHAOS"),
  ...
)
}
\arguments{
\item{labels}{A vector containing the labels to be evaluated.}

\item{location}{A numerical matrix containing the location information, with
rows as samples and columns as location dimensions.}

\item{k}{The size of the spatial neighborhood to look at for each spot.
This is used for calculating PAS and ELSA scores.}

\item{metrics}{The metrics to compute. See below for more details.}

\item{...}{Optional arguments for \code{\link[=PAS]{PAS()}}.}
}
\value{
A named vector containing metric values. Possible metrics are:
\item{PAS}{Proportion of abnormal spots (PAS score).}
\item{ELSA}{Entropy-based Local indicator of Spatial Association
(ELSA score).}
\item{CHAOS}{Spatial Chaos Score.}
\item{MPC}{Modified partition coefficient}
\item{PC}{Partition coefficient}
\item{PE}{Partition entropy}
}
\description{
Computes a selection of internal clustering evaluation metrics for spatial
data at the dataset level. MPC, PC and PE are internal metrics for fuzzy
clustering, and their implementations in package \code{fclust} are used.
}
\references{
Yuan, Zhiyuan, et al., 2024; 10.1038/s41592-024-02215-8

Naimi, Babak, et al., 2019; 10.1016/j.spasta.2018.10.001

Wang, et al., 2022; 10.1016/j.ins.2022.11.010
}
\keyword{internal}
