% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpatialExternalMetrics.R
\name{getSpatialGlobalExternalMetrics}
\alias{getSpatialGlobalExternalMetrics}
\title{Compute dataset-level external evaluation metrics for spatially-resolved data}
\usage{
getSpatialGlobalExternalMetrics(
  true,
  pred,
  location,
  k = 6,
  alpha = 0.5,
  metrics = c("nsRI", "nsARI", "nsWH", "nsAWH", "nsWC", "nsAWC", "nsAccuracy",
    "SpatialRI", "SpatialARI"),
  fuzzy_true = TRUE,
  fuzzy_pred = FALSE,
  lowMemory = NULL,
  ...
)
}
\arguments{
\item{true}{A vector containing the labels of the true classes. Must be a
vector of characters, integers, numerics, or a factor, but not a list.}

\item{pred}{A vector containing the labels of the predicted clusters. Must
be a vector of characters, integers, numerics, or a factor, but not a list.}

\item{location}{A matrix or data.frame of coordinates}

\item{k}{The number of neighbors used when calculating the fuzzy
class memberships for fuzzy metrics, or when calculating the weighted
accuracy.}

\item{alpha}{The parameter to control to what extend the spot itself
contribute to the class composition calculation. \code{"equal"} means it is
weighted the same as other neighbors. A numeric value between \code{0} and \code{1}
means the weight of the frequency contribution for the spot itself, and the
frequency contribution for its knn is then \code{1-alpha}. By default \code{0.5}.}

\item{metrics}{a vector of metric names to compute.}

\item{fuzzy_true}{Logical; whether to compute fuzzy class memberships
for \code{true}.}

\item{fuzzy_pred}{Logical; whether to compute fuzzy class memberships
for \code{pred}.}

\item{lowMemory}{Logical, whether to use a low memory mode. This is only
useful when\code{hardTrue} and \code{fuzzyPred} is used. If \code{TRUE},
the function will compute the metrics in a low memory mode, which is
slower but uses less memory. If \code{FALSE}, the function will compute the
metrics in a high memory mode, which is faster but uses more memory.
By default it is set automatically based on the size of the input data. See
\code{\link{fuzzyHardMetrics}}.}

\item{...}{Optional params for \code{\link{fuzzyPartitionMetrics}} or
\code{\link{findSpatialKNN}}.}
}
\value{
A data.frame of metrics.
}
\description{
Computes a selection of external clustering evaluation metrics for spatial
data at the dataset level. Options include a series of fuzzy pair-counting
metrics and set matching-based accuracy.
}
\keyword{internal}
