% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpatialExternalMetrics.R
\name{getSpatialElementExternalMetrics}
\alias{getSpatialElementExternalMetrics}
\title{getSpatialElementExternalMetrics}
\usage{
getSpatialElementExternalMetrics(
  true,
  pred,
  location,
  k = 6,
  alpha = 0.5,
  metrics = c("nsSPC", "NPC", "SpatialSPC"),
  fuzzy_true = TRUE,
  fuzzy_pred = FALSE,
  ...
)
}
\arguments{
\item{true}{A vector containing the labels of the true classes. Must be a
vector of characters, integers, numerics, or a factor, but not a list.}

\item{pred}{A vector containing the labels of the predicted clusters. Must
be a vector of characters, integers, numerics, or a factor, but not a list.}

\item{location}{A matrix or data.frame of coordinates}

\item{k}{The number of neighbors used when calculating the fuzzy
class memberships for fuzzy metrics, or when calculating the weighted
accuracy.}

\item{alpha}{The parameter to control to what extend the spot itself
contribute to the class composition calculation. \code{"equal"} means it is
weighted the same as other neighbors. A numeric value between \code{0} and \code{1}
means the weight of the frequency contribution for the spot itself, and the
frequency contribution for its knn is then \code{1-alpha}. By default \code{0.5}.}

\item{metrics}{a vector of metric names to compute.}

\item{fuzzy_true}{Logical; whether to compute fuzzy class memberships
for \code{true}.}

\item{fuzzy_pred}{Logical; whether to compute fuzzy class memberships
for \code{pred}.}

\item{...}{Optional params for \code{\link[=getFuzzyPartitionElementMetrics]{getFuzzyPartitionElementMetrics()}} or
\code{\link[=findSpatialKNN]{findSpatialKNN()}}.}
}
\value{
A data.frame of metrics.
}
\description{
Computes a selection of external clustering evaluation metrics for spatial
data at the element level.
}
\keyword{internal}
