% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpatialInternalMetrics.R
\name{getSpatialClassInternalMetrics}
\alias{getSpatialClassInternalMetrics}
\title{Compute class-level internal evaluation metrics for spatially-resolved data}
\usage{
getSpatialClassInternalMetrics(
  labels,
  location,
  k = 6,
  metrics = c("CHAOS", "PAS", "ELSA"),
  ...
)
}
\arguments{
\item{labels}{A vector containing the labels to be evaluated.}

\item{location}{A numerical matrix containing the location information, with
rows as samples and columns as location dimensions.}

\item{k}{The size of the spatial neighborhood to look at for each spot.
This is used for calculating PAS and ELSA scores.}

\item{metrics}{Possible metrics: "CHAOS", "PAS" and "ELSA".}

\item{...}{Optional params for \code{\link[=PAS]{PAS()}}.}
}
\value{
A dataframe of metric values.
}
\description{
Computes a selection of internal clustering evaluation metrics for spatial
data for each class.
}
\keyword{internal}
