% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFuzzyPartitionMetrics.R
\name{getFuzzyPartitionMetrics}
\alias{getFuzzyPartitionMetrics}
\title{Compute external metrics for fuzzy clusterings}
\usage{
getFuzzyPartitionMetrics(
  hardTrue = NULL,
  fuzzyTrue = NULL,
  hardPred = NULL,
  fuzzyPred = NULL,
  metrics = c("fuzzyWH", "fuzzyAWH", "fuzzyWC", "fuzzyAWC"),
  level = "class",
  nperms = NULL,
  verbose = TRUE,
  BPPARAM = BiocParallel::SerialParam(),
  useNegatives = TRUE,
  usePairs = NULL,
  lowMemory = NULL,
  ...
)
}
\arguments{
\item{hardTrue}{An atomic vector coercible to a factor or integer vector
containing the true hard labels.}

\item{fuzzyTrue}{A object coercible to a numeric matrix with membership
probability of elements (rows) in clusters (columns).}

\item{hardPred}{An atomic vector coercible to a factor or integer vector
containing the predicted hard labels.}

\item{fuzzyPred}{A object coercible to a numeric matrix with membership
probability of elements (rows) in clusters (columns).}

\item{metrics}{The metrics to compute. See details.}

\item{level}{The level to calculate the metrics. Options include
\code{"element"}, \code{"class"} and \code{"dataset"}.}

\item{nperms}{The number of permutations (for correction for chance). If
NULL (default), a first set of 10 permutations will be run to estimate
whether the variation across permutations is above 0.0025, in which case
more (max 1000) permutations will be run.}

\item{verbose}{Logical; whether to print info and warnings, including the
standard error of the mean across permutations (giving an idea of the
precision of the adjusted metrics).}

\item{BPPARAM}{BiocParallel params for multithreading (default none)}

\item{useNegatives}{Logical; whether to include negative pairs in the
concordance score (tends to result in a larger overall concordance and
lower dynamic range of the score). Default TRUE.}

\item{usePairs}{Logical; whether to compute over pairs instead of elements
Recommended and TRUE by default.}

\item{lowMemory}{Logical, whether to use a low memory mode. This is only
useful when\code{hardTrue} and \code{fuzzyPred} is used. If \code{TRUE},
the function will compute the metrics in a low memory mode, which is
slower but uses less memory. If \code{FALSE}, the function will compute the
metrics in a high memory mode, which is faster but uses more memory.
By default it is set automatically based on the size of the input data. See
\code{\link{fuzzyHardMetrics}}.}

\item{...}{Optional arguments for \code{\link{fuzzyPartitionMetrics}}:
\code{tnorm}. Only useful when \code{fuzzyTrue} and \code{fuzzyPred} is used.}
}
\value{
A dataframe of metric results.
}
\description{
Computes a selection of external fuzzy clustering evaluation metrics.
}
\details{
The allowed values for \code{metrics} depend on the value of \code{level}:
\itemize{
\item If \code{level = "element"}, the allowed \code{metrics} are: \code{"fuzzySPC"}.
\item If \code{level = "class"}, the allowed \code{metrics} are: \code{"fuzzyWH"},
\code{"fuzzyAWH"}, \code{"fuzzyWC"}, \code{"fuzzyAWC"}.
\item If \code{level = "dataset"}, the allowed \code{metrics} are: \code{"fuzzyRI"},
\code{"fuzzyARI"}, \code{"fuzzyWH"}, \code{"fuzzyAWH"}, \code{"fuzzyWC"}, \code{"fuzzyAWC"}.
}
}
\examples{
# generate fuzzy partitions:
m1 <- matrix(c(0.95, 0.025, 0.025, 
               0.98, 0.01, 0.01, 
               0.96, 0.02, 0.02, 
               0.95, 0.04, 0.01, 
               0.95, 0.01, 0.04, 
               0.99, 0.005, 0.005, 
               0.025, 0.95, 0.025, 
               0.97, 0.02, 0.01, 
               0.025, 0.025, 0.95), 
               ncol = 3, byrow=TRUE)
m2 <- matrix(c(0.95, 0.025, 0.025,  
               0.98, 0.01, 0.01, 
               0.96, 0.02, 0.02, 
               0.025, 0.95, 0.025, 
               0.02, 0.96, 0.02, 
               0.01, 0.98, 0.01, 
               0.05, 0.05, 0.95, 
               0.02, 0.02, 0.96, 
               0.01, 0.01, 0.98), 
               ncol = 3, byrow=TRUE)
colnames(m1) <- colnames(m2) <- LETTERS[seq_len(3)]
getFuzzyPartitionMetrics(fuzzyTrue=m1,fuzzyPred=m2, level="class")

# generate a fuzzy truth:
fuzzyTrue <- matrix(c(
  0.95, 0.025, 0.025, 
  0.98, 0.01, 0.01, 
  0.96, 0.02, 0.02, 
  0.95, 0.04, 0.01, 
  0.95, 0.01, 0.04, 
  0.99, 0.005, 0.005, 
  0.025, 0.95, 0.025, 
  0.97, 0.02, 0.01, 
  0.025, 0.025, 0.95), 
  ncol = 3, byrow=TRUE)
# a hard truth:
hardTrue <- apply(fuzzyTrue,1,FUN=which.max)
# some predicted labels:
hardPred <- c(1,1,1,1,1,1,2,2,2)
getFuzzyPartitionMetrics(hardPred=hardPred, hardTrue=hardTrue, 
fuzzyTrue=fuzzyTrue, nperms=3, level="class")
getFuzzyPartitionMetrics(hardTrue=hardPred, hardPred=hardTrue, 
fuzzyPred=fuzzyTrue, nperms=3, level="class")
}
