% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{emb2snn}
\alias{emb2snn}
\title{Computes shared nearest neighbors from embedding}
\usage{
emb2snn(x, k, type = "rank", BNPARAM = NULL)
}
\arguments{
\item{x}{A numeric matrix (with features as columns and items as
rows) from which nearest neighbors will be computed.}

\item{k}{The number of nearest neighbors.}

\item{type}{A string specifying the type of weighting scheme to use for
shared neighbors.
Possible choices include "rank", "number", and "jaccard". See \code{type} in
\code{\link[bluster:makeSNNGraph]{bluster::neighborsToSNNGraph()}} for details.}

\item{BNPARAM}{A BiocNeighbors parameter object to compute kNNs. Ignored
unless the input is a matrix or data.frame. If omitted, the Annoy
approximation will be used if there are more than 500 elements.}
}
\value{
An igraph object.
}
\description{
computes shared nearest neighbors from embedding.
}
\examples{
d1 <- mockData()
emb2snn(as.matrix(d1[,seq_len(2)]),k=5)
}
