% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbcv.R
\name{dbcv}
\alias{dbcv}
\title{Calculate DBCV Metric}
\usage{
dbcv(
  X,
  labels,
  distance = "euclidean",
  noise_id = -1,
  check_duplicates = FALSE,
  use_igraph_mst = TRUE,
  BPPARAM = BiocParallel::SerialParam(),
  ...
)
}
\arguments{
\item{X}{Numeric matrix of samples.}

\item{labels}{Integer vector of cluster IDs.}

\item{distance}{String specifying the distance metric. \code{"sqeuclidean"}, or
possible \code{method} in \code{stats::dist()}. By default \code{"euclidean"}.}

\item{noise_id}{Integer, the cluster ID in \code{y} for noise (default \code{-1}).}

\item{check_duplicates}{Logical flag to check for duplicate samples.}

\item{use_igraph_mst}{Logical flag to use \code{igraph}'s MST
implementation. Currently only \code{mst} from \code{igraph} is implemented.}

\item{BPPARAM}{BiocParallel params for multithreading (default none)}

\item{...}{Ignored}
}
\value{
A list:
\item{vcs}{Numeric vector of validity index for each cluster.}
\item{dbcv}{Numeric value representing the overall DBCV metric.}
}
\description{
Compute the DBCV (Density-Based Clustering Validation) metric.
}
\details{
This implementation will not fully reproduce the results of other
existing implementations (e.g. \url{https://github.com/FelSiq/DBCV}) due to
the different algorithms used for computing the Minimum Spanning Tree.
}
\examples{
data(noisy_moon)
data <- noisy_moon
dbcv(data[, c("x", "y")], data$kmeans_label)
dbcv(data[, c("x", "y")], data$hdbscan_label)
}
\references{
Davoud Moulavi, et al. 2014; 10.1137/1.9781611973440.96.
}
