% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialMetrics.R
\name{PAS}
\alias{PAS}
\title{Calculate PAS score}
\usage{
PAS(labels, location, k = 10, ...)
}
\arguments{
\item{labels}{Cluster labels.}

\item{location}{A numerical matrix containing the location information, with
rows as samples and columns as location dimensions.}

\item{k}{Number of nearest neighbors.}

\item{...}{Optional params for \code{\link[=findSpatialKNN]{findSpatialKNN()}}.}
}
\value{
A numeric value for PAS score, and a boolean vector about the
abnormal spots.
}
\description{
PAS score measures the clustering performance by calculating
the randomness of the spots that located outside of the spatial region where
it was clustered to. Lower PAS score indicates better spatial domian
clustering performance.
}
\examples{
data(sp_toys)
data <- sp_toys
PAS(data$label, data[,c("x", "y")], k=6)
PAS(data$p1, data[,c("x", "y")], k=6)
PAS(data$p2, data[,c("x", "y")], k=6)
}
