% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbc_plot.R
\name{sbc_plot}
\alias{sbc_plot}
\title{Plot QCRSC corrected outputs}
\usage{
sbc_plot(
  df,
  corrected_df,
  classes,
  batch,
  indexes = NULL,
  qc_label = "QC",
  output = "sbcms_plots.pdf"
)
}
\arguments{
\item{df}{A matrix-like (e.g. an ordinary matrix, a data frame) or 
\link[SummarizedExperiment]{RangedSummarizedExperiment-class} object with 
all values of class \code{numeric()} or \code{integer()} of peak 
intensities, areas or other quantitative characteristic.}

\item{corrected_df}{Output from \link[pmp]{QCRSC} function.}

\item{classes}{\code{character()}, vector of class labels. Must be the same 
length as the number of sample in the input peak table. If input is 
\code{SummarizedExperiment} object, use 
\code{SummarizedExperiment_object$meta_data_column_name}.}

\item{batch}{\code{numeric()} or \code{character()}, a vector indicating
the batch each sample was measured in. If only one batch was measured then
all values should be set to 1}

\item{indexes}{\code{numeric()}, a vector defining which features to plot.
If set to \code{NULL} will plot the first 100.}

\item{qc_label}{\code{character(1)} or \code{NULL}, class label used to
identify QC samples.}

\item{output}{\code{character()}, a filename of the output pdf file. 
Can include the path. If set to \code{NULL} output will be list object 
containing class \code{ggplot} plots.}
}
\value{
Pdf file or \code{list()} object \code{ggplot} class showing data 
before and after signal correction.
}
\description{
Plot the output from signal batch correction for the selected or
the first 100 features.
}
\examples{

order <- c(1:ncol(MTBLS79))
data <- MTBLS79[1:10, ]

out <- QCRSC(df =data, order=order, batch=MTBLS79$Batch, 
   classes=MTBLS79$Class, spar=0, minQC=4)
plots <- sbc_plot (df=data, corrected_df=out, classes=MTBLS79$Class,
   batch=MTBLS79$Batch, output=NULL) 

}
