% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalisation.R
\name{pqn_normalisation}
\alias{pqn_normalisation}
\title{Probabilistic quotient normalisation (PQN)}
\usage{
pqn_normalisation(
  df,
  classes,
  qc_label,
  ref_mean = NULL,
  qc_frac = 0,
  sample_frac = 0,
  ref_method = "mean"
)
}
\arguments{
\item{df}{A matrix-like (e.g. an ordinary matrix, a data frame) or 
\link[SummarizedExperiment]{RangedSummarizedExperiment-class} object with 
all values of class \code{numeric()} or \code{integer()} of peak 
intensities, areas or other quantitative characteristic.}

\item{classes}{\code{character()}, vector of class labels. Must be the same 
length as the number of sample in the input peak table. If input is 
\code{SummarizedExperiment} object, use 
\code{SummarizedExperiment_object$meta_data_column_name}.}

\item{qc_label}{\code{character(1)} or \code{NULL}, class label used to
identify QC samples.}

\item{ref_mean}{\code{numeric()} or \code{NULL}, Vector of reference mean
values to use instead of calculating from QC sample group. If set to 
\code{NULL}, QC sample data will be used.}

\item{qc_frac}{\code{numeric()} A value between 0 and 1 to indicate the 
minimum proportion of QC samples a feature must be present in for it to be included 
when computing the reference. Default \code{qc_frac = 0}.}

\item{sample_frac}{\code{numeric()} A value between 0 and 1 to indicate the 
minimum proportion of samples a feature must be present in for it to be considered 
when computing the normalisation coefficients. Default \code{sample_frac = 0}.}

\item{ref_method}{\code{character()} Method used to compute the reference from
the QC samples. Default \code{ref_method = 'mean'}. Allowed
values are "mean" or "median".}
}
\value{
Object of class \code{SummarizedExperiment}. If input data are 
matrix-like (e.g. an ordinary matrix, a data frame) object, the same R data 
structure as the input will be returned with all values of the data type.

\code{numeric()}.
}
\description{
For every feature the mean response is calculated across all QC samples. A 
reference vector is then generated. The median between the reference vector
and every sample is computed obtaining a vector of coefficients related to
each sample. Each sample is then divided by the median value of the vector
of coefficients; this median value is different for each sample. This 
method was adapted by Dieterle et al. (2006) (see references). Its purpose 
is to take into account the concentration changes of some metabolite 
features that affect limited regions of the data.
}
\examples{
df <- MTBLS79[ , MTBLS79$Batch==1]
pqn_normalisation(df=df,
    classes=df$Class, qc_label='QC')

}
\references{
Dieterle F. et al., Anal. Chem., 78(13), 2006. 
http://dx.doi.org/10.1021/ac051632c
}
