% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_peaks_by_rsd}
\alias{filter_peaks_by_rsd}
\title{Filter features by RSD\% of QC samples}
\usage{
filter_peaks_by_rsd(df, max_rsd, classes, qc_label, remove_peaks = TRUE)
}
\arguments{
\item{df}{A matrix-like (e.g. an ordinary matrix, a data frame) or 
\link[SummarizedExperiment]{RangedSummarizedExperiment-class} object with 
all values of class \code{numeric()} or \code{integer()} of peak 
intensities, areas or other quantitative characteristic.}

\item{max_rsd}{\code{numeric()}, threshold of QC RSD\% value}

\item{classes}{\code{character()}, vector of class labels. Must be the same 
length as the number of sample in the input peak table. If input is 
\code{SummarizedExperiment} object, use 
\code{SummarizedExperiment_object$meta_data_column_name}.}

\item{qc_label}{\code{character(1)} or \code{NULL}, class label used to
identify QC samples.}

\item{remove_peaks}{\code{logical(1)}, remove filtered features from peak 
matrix or not.}
}
\value{
Object of class \code{SummarizedExperiment}. If input data are a 
matrix-like (e.g. an ordinary matrix, a data frame) object, function returns 
\code{numeric()} matrix-like object of filtered data set. Function 
\code{flags} are added to the object \code{attributes} and is a 
\link[S4Vectors]{DataFrame-class} with five columns. The same 
\code{DataFrame-class} object containing flags is added to \code{rowData()} 
element of \code{SummarizedExperiment} object as well.\cr
\cr
Columns in \code{rowData()} or \code{flags} element contain: \cr
\code{rsd_QC} \code{numeric()}, RSD\% value of QC samples per feature; \cr
\code{rsd_flags} \code{integer()},if 0 feature is flagged to be removed. \cr
}
\description{
Metabolomics datasets often contain 'features' with irreproducible peak 
intensity values, or with large numbers of missing values. This tool 
facilitates the remove of such features from a data matrix, based upon 
relative standard deviation of intensity values for a given feature within 
specified QC samples.
}
\examples{

df <- MTBLS79[ ,MTBLS79$Batch == 1]
out <- filter_peaks_by_rsd(df=df, max_rsd=20,
    classes=df$Class, qc_label='QC')

}
