% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-filter.R
\name{filter}
\alias{filter}
\alias{filter.PlySummarizedExperiment}
\title{filter PlySummarizedExperiment}
\usage{
\method{filter}{PlySummarizedExperiment}(.data, ..., .preserve = FALSE)
}
\arguments{
\item{.data}{An object Inheriting from \code{PlySummarizedExperiment}, the wrapper
class for \code{SummarizedExperiment} objects}

\item{...}{conditions to filter on. These must be wrapped in \code{cols()} and or
\code{rows()}}

\item{.preserve}{Relevant when the .data input is grouped. If .preserve = FALSE
(the default), the grouping structure is recalculated based on the resulting data,
i.e. the number of groups may change.}
}
\value{
an object inheriting \code{PlySummarizedExperiment} class
}
\description{
The \code{filter()} function is used to subset an object, returning the observations
that satisfy your conditions. An observation must return TRUE for all conditions
within a context to be retained. Note, to guarantee a valid
\code{PlySummarizedExperiment} is returned, filtering in the \code{assays} evaluation
context is disabled.
}
\examples{
# example code
filter(
  se_simple,
  rows(length > 30),
  cols(condition == "drug")
)

filter(
  se_simple,
  rows(rowSums(.assays_asis$counts) > 40),
  cols(colSums(.assays_asis$counts) < 50)
)

# assay context is disabled
filter(
  se_simple,
  counts > 12
) |> try()

# convert to `data.frame` first
as.data.frame(se_simple) |>
  filter(counts > 12)

}
