% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-slice.R
\name{slice.Ranges}
\alias{slice.Ranges}
\alias{slice.GroupedGenomicRanges}
\alias{slice.GroupedIntegerRanges}
\title{Choose rows by their position}
\usage{
\method{slice}{Ranges}(.data, ..., .preserve = FALSE)

\method{slice}{GroupedGenomicRanges}(.data, ..., .preserve = FALSE)

\method{slice}{GroupedIntegerRanges}(.data, ..., .preserve = FALSE)
}
\arguments{
\item{.data}{a \code{Ranges} object}

\item{...}{Integer row values indicating rows to keep. If \code{.data} has
been grouped via \code{\link[=group_by.GenomicRanges]{group_by.GenomicRanges()}}, then the positions are selected within each group.}

\item{.preserve}{when FALSE (the default) the grouping structure is
recomputed, otherwise it is kept as is. Currently ignored.}
}
\value{
a GRanges object
}
\description{
Choose rows by their position
}
\examples{
df <- data.frame(start = 1:10,
                 width = 5,
                 seqnames = "seq1",
                 strand = sample(c("+", "-", "*"), 10, replace = TRUE),
                 gc = runif(10))
rng <- as_granges(df)
dplyr::slice(rng, 1:2)
dplyr::slice(rng, -n())
dplyr::slice(rng, -5:-n())

by_strand <- group_by(rng, strand)

# slice with group by finds positions within each group
dplyr::slice(by_strand, n())
dplyr::slice(by_strand, which.max(gc))

# if the index is beyond the number of groups slice are ignored
dplyr::slice(by_strand, 1:3)


}
