% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-overlap-self-joins.R
\name{join_overlap_self}
\alias{join_overlap_self}
\alias{join_overlap_self_within}
\alias{join_overlap_self_directed}
\alias{join_overlap_self_within_directed}
\title{Find overlaps within a Ranges object}
\usage{
join_overlap_self(x, maxgap, minoverlap)

join_overlap_self_within(x, maxgap, minoverlap)

join_overlap_self_directed(x, maxgap, minoverlap)

join_overlap_self_within_directed(x, maxgap, minoverlap)
}
\arguments{
\item{x}{A Ranges object}

\item{maxgap, minoverlap}{The maximimum gap between intervals as an integer
greater than or equal to zero. The minimum amount of overlap between intervals
as an integer greater than zero, accounting for the maximum gap.}
}
\value{
a Ranges object
}
\description{
Find overlaps within a Ranges object
}
\details{
Self overlaps find any overlaps (or overlaps within or overlaps
directed) between a ranges object and itself.
}
\examples{
query <- data.frame(start = c(5,10, 15,20), width = 5, gc = runif(4)) \%>\%
             as_iranges()

join_overlap_self(query)

# -- GRanges objects, strand is ignored by default
query  <- data.frame(seqnames = "chr1",
               start = c(11,101),
               end = c(21, 200),
               name = c("a1", "a2"),
               strand = c("+", "-"),
               score = c(1,2)) \%>\%
           as_granges()

# ignores strandedness
join_overlap_self(query)
join_overlap_self_within(query)
# adding directed prefix includes strand
join_overlap_self_directed(query)


}
\seealso{
\code{\link[=find_overlaps]{find_overlaps()}}, \code{\link[=join_overlap_inner]{join_overlap_inner()}}
}
