% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-bind.R
\name{interweave}
\alias{interweave}
\title{Interweave a pair of Ranges objects together}
\usage{
interweave(left, right, .id = NULL)
}
\arguments{
\item{left, right}{Ranges objects.}

\item{.id}{When supplied a new column that represents the origin column
and is linked to each row of the resulting Ranges object.}
}
\value{
a Ranges object
}
\description{
Interweave a pair of Ranges objects together
}
\details{
The output of \code{interweave()} takes pairs of Ranges
objects and combines them into a single  Ranges object. If an .id
argument is supplied, an origin column with name .id is created indicated which side
the resulting Range comes from (eit)
}
\examples{
gr <- as_granges(data.frame(start = 10:15,
                            width = 5,
                            seqnames = "seq1",
                            strand = c("+", "+", "-", "-", "+", "*")))
interweave(flank_left(gr, width = 5L), flank_right(gr, width = 5L))
interweave(flank_left(gr, width = 5L), flank_right(gr, width = 5L), .id = "origin")
}
