% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-pull.R
\name{pull-ranges}
\alias{pull-ranges}
\alias{pull.Ranges}
\title{Extract a single column from a Ranges object as a vector}
\usage{
\method{pull}{Ranges}(.data, var = -1, name = NULL, ...)
}
\arguments{
\item{.data}{a \code{Ranges} object}

\item{var}{A variable specified as:
\itemize{
\item a literal variable name
\item a positive integer, giving the position counting from the left. In this
case order is start, end, width, (strand, seqnames), gc and score.
\item a negative integer, giving the position counting from the right.
The default returns the last column (on the assumption that's the column
you've created most recently). This argument is taken by expression and
supports quasiquotation (you can unquote column names and column locations).
}}

\item{name}{An optional parameter that specifies the column to be used as
names for a named vector. Specified in a similar manner as \code{var}.}

\item{...}{For use by methods.}
}
\description{
Extract a single column from a Ranges object as a vector
}
\examples{
df <- data.frame(start = 1:10,
                 width = 5,
                 seqnames = "seq1",
                 strand = sample(c("+", "-", "*"), 10, replace = TRUE),
                 gc = runif(10),
                 score = rpois(10, 2))
rng <- as_granges(df)

# Pull parts of the range
pull(rng, start)
# equivalent to start(rng)

# Pull by column name
pull(rng, gc)
pull(rng, score)

# Pull by position (positive from left, negative from right)
pull(rng, 1)    # First metadata column
pull(rng, -1)   # Last metadata column (default)
pull(rng, -2)   # Second to last metadata column

# Pull with names
pull(rng, score, name = gc)

}
\seealso{
\code{\link[dplyr:pull]{dplyr::pull()}}
}
