% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-mutate.R
\name{mutate.Ranges}
\alias{mutate.Ranges}
\title{Modify a Ranges object}
\usage{
\method{mutate}{Ranges}(.data, ...)
}
\arguments{
\item{.data}{a \code{Ranges} object}

\item{...}{Pairs of name-value expressions. The name-value pairs can either
create new metadata columns or modify existing ones.}
}
\value{
a Ranges object
}
\description{
Modify a Ranges object
}
\examples{
df <- data.frame(start = 1:10,
                 width = 5,
                 seqnames = "seq1",
                 strand = sample(c("+", "-", "*"), 10, replace = TRUE),
                 gc = runif(10))
rng <- as_granges(df)

# mutate adds new columns
rng \%>\%
    mutate(avg_gc = mean(gc), row_id = 1:n())
# can also compute on newly created columns
rng \%>\%
    mutate(score = gc * width, score2 = score + 1)
# group by partitions the data and computes within each group
rng \%>\%
    group_by(strand) \%>\%
    mutate(avg_gc = mean(gc), row_id = 1:n())

# mutate can be used in conjuction with anchoring to resize ranges
rng \%>\%
    mutate(width = 10)
# by default width modfication fixes by start
rng \%>\%
    anchor_start() \%>\%
    mutate(width = 10)
# fix by end or midpoint
rng \%>\%
    anchor_end() \%>\%
    mutate(width = width + 1)
rng \%>\%
    anchor_center() \%>\%
    mutate(width = width + 1)
# anchoring by strand
rng \%>\%
    anchor_3p() \%>\%
    mutate(width = width * 2)
rng \%>\%
    anchor_5p() \%>\%
    mutate(width = width * 2)
}
