% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift.R
\name{plyranges-shift}
\alias{plyranges-shift}
\alias{shift_downstream}
\alias{shift_downstream.Ranges}
\alias{shift_downstream.PinnedGInteractions}
\alias{shift_upstream}
\alias{shift_upstream.Ranges}
\alias{shift_upstream.PinnedGInteractions}
\alias{shift_right}
\alias{shift_right.Ranges}
\alias{shift_right.PinnedGInteractions}
\alias{shift_left}
\alias{shift_left.Ranges}
\alias{shift_left.PinnedGInteractions}
\title{Shift pinned anchors of a GInteractions object with plyranges}
\usage{
shift_downstream(x, shift)

\method{shift_downstream}{Ranges}(x, shift)

\method{shift_downstream}{PinnedGInteractions}(x, shift)

shift_upstream(x, shift)

\method{shift_upstream}{Ranges}(x, shift)

\method{shift_upstream}{PinnedGInteractions}(x, shift)

shift_right(x, shift)

\method{shift_right}{Ranges}(x, shift)

\method{shift_right}{PinnedGInteractions}(x, shift)

shift_left(x, shift)

\method{shift_left}{Ranges}(x, shift)

\method{shift_left}{PinnedGInteractions}(x, shift)
}
\arguments{
\item{x}{a PinnedGInteractions object}

\item{shift}{The amount to move the genomic interval in the Ranges object
by. Either a non-negative integer vector of length 1 or an integer vector
the same length as x.}
}
\value{
A PinnedGInteractions object
}
\description{
Shift pinned anchors of a GInteractions object with plyranges
}
\examples{
gi <- read.table(text = "
chr1 11 20 chr1 21 30 + +
chr1 11 20 chr1 51 55 + +
chr1 11 30 chr1 51 55 - -
chr1 11 30 chr2 51 60 - -",
col.names = c(
  "seqnames1", "start1", "end1", 
  "seqnames2", "start2", "end2", "strand1", "strand2")
) |> 
  as_ginteractions() |> 
  mutate(score = runif(4), type = c('cis', 'cis', 'cis', 'trans'))

####################################################################
# 1. Simple shifting
####################################################################

gi 

gi |> pin_by("first") |> shift_left(15)

gi |> pin_by("second") |> shift_downstream(10)

####################################################################
# 2. Chained shifting of each set of anchors
####################################################################

gi |> 
  pin_by("first") |> shift_downstream(20) |> 
  pin_by("second") |> shift_upstream(20)
}
