% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/pin.R
\name{pin}
\alias{pin}
\alias{pin_by}
\alias{pinned_anchors}
\alias{unpin}
\alias{ginteractions-pin}
\alias{pin,GroupedGInteractions,character-method}
\alias{pin,GroupedGInteractions,numeric-method}
\alias{pin,GInteractions,character-method}
\alias{pin,GInteractions,numeric-method}
\alias{pin,PinnedGInteractions,missing-method}
\alias{pin,PinnedGInteractions,character-method}
\alias{pin,PinnedGInteractions,numeric-method}
\alias{pin,AnchoredPinnedGInteractions,character-method}
\alias{pin,AnchoredPinnedGInteractions,numeric-method}
\alias{pin_first}
\alias{pin_second}
\alias{pin_anchors1}
\alias{pin_anchors2}
\alias{unpin,AnchoredPinnedGInteractions-method}
\alias{unpin,PinnedGInteractions-method}
\alias{unpin,GInteractions-method}
\alias{pinned_anchors,PinnedGInteractions-method}
\alias{pinned_anchors,AnchoredPinnedGInteractions-method}
\title{Pin GInteractions by anchors set (anchors1 or anchors2).}
\usage{
pin(x, anchors)

pin_by(x, anchors)

pinned_anchors(x)

unpin(x)

\S4method{pin}{GroupedGInteractions,character}(x, anchors)

\S4method{pin}{GroupedGInteractions,numeric}(x, anchors)

\S4method{pin}{GInteractions,character}(x, anchors)

\S4method{pin}{GInteractions,numeric}(x, anchors)

\S4method{pin}{PinnedGInteractions,missing}(x, anchors)

\S4method{pin}{PinnedGInteractions,character}(x, anchors)

\S4method{pin}{PinnedGInteractions,numeric}(x, anchors)

\S4method{pin}{AnchoredPinnedGInteractions,character}(x, anchors)

\S4method{pin}{AnchoredPinnedGInteractions,numeric}(x, anchors)

pin_first(x)

pin_second(x)

pin_anchors1(x)

pin_anchors2(x)

\S4method{unpin}{AnchoredPinnedGInteractions}(x)

\S4method{unpin}{PinnedGInteractions}(x)

\S4method{unpin}{GInteractions}(x)

\S4method{pinned_anchors}{PinnedGInteractions}(x)

\S4method{pinned_anchors}{AnchoredPinnedGInteractions}(x)
}
\arguments{
\item{x}{a GInteractions object}

\item{anchors}{Anchors to pin on ("first" or "second")}
}
\value{
\itemize{
\item \verb{pin_*} functions return a PinnedGInteractions object.
\item \code{pin} returns a numerical value indicating which set of anchors is pinned.
\item \code{unpin} removes the pinning of a PinnedGInteractions object.
\item \code{pinned_anchors} returns an (Anchored)GenomicRanges object corresponding
to the pinned anchors of a PinnedGInteractions object.
}
}
\description{
Pin GInteractions by anchors set (anchors1 or anchors2).
}
\examples{
gi <- read.table(text = "
chr1 11 20 chr1 21 30
chr1 11 20 chr1 51 55
chr1 11 30 chr1 51 55
chr1 11 30 chr2 51 60",
col.names = c(
    "seqnames1", "start1", "end1", 
    "seqnames2", "start2", "end2")
) |> 
  as_ginteractions() |> 
  mutate(type = c('cis', 'cis', 'cis', 'trans'), score = runif(4))

####################################################################
# 1. Pin by first anchors
####################################################################

gi |> pin_by("first")

gi |> pin_first()

gi |> pin_anchors1()

####################################################################
# 2. Pin by second anchors
####################################################################

gi |> pin_by("second")

gi |> pin_second()

gi |> pin_anchors2()

####################################################################
# 3. Unpin
####################################################################

gi |> pin("second") |> unpin()
}
