% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{ginteractions-export}
\alias{ginteractions-export}
\alias{write_bedpe}
\alias{write_pairs}
\title{Export GInteractions as \code{bedpe} or \code{pairs} files}
\usage{
write_bedpe(x, file, scores = NULL)

write_pairs(x, file, seqlengths = Seqinfo::seqlengths(x))
}
\arguments{
\item{x}{a GInteractions object.}

\item{file}{path to a \code{.bedpe} or \code{.pairs} file to save the genomic interactions.}

\item{scores}{Name of column to extract scores from.}

\item{seqlengths}{Named vector indicating the chromosome sizes.}
}
\value{
TRUE
}
\description{
\verb{write_*} functions are provided to export a GInteractions
object into these two file formats. See 4DN documentation
(https://github.com/4dn-dcic/pairix/blob/master/pairs_format_specification.md)
and UCSC documentation
(https://bedtools.readthedocs.io/en/latest/content/general-usage.html#bedpe-format)
for more details.
}
\examples{
gi <- read.table(text = "
chr1 100 200 chr1 5000 5100 bedpe_example1 30 + -
chr1 1000 5000 chr1 3000 3800 bedpe_example2 100 + -",
col.names = c(
  "seqnames1", "start1", "end1", 
  "seqnames2", "start2", "end2", "name", "score", "strand1", "strand2")
) |> as_ginteractions()

write_bedpe(gi, 'gi.bedpe')
write_pairs(gi, 'gi.pairs')
}
