% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pageGuideVertical.R
\name{pageGuideVertical}
\alias{pageGuideVertical}
\title{Draw a vertical guideline at a specified x-coordinate on a 
plotgardener page}
\usage{
pageGuideVertical(
    x,
    default.units = "inches",
    linecolor = "grey55",
    params = NULL,
    ...
)
}
\arguments{
\item{x}{A numeric or unit object specifying x-coordinate of guide.}

\item{default.units}{A string indicating the default units to use
if \code{x} is only given as a numeric.
Default value is \code{default.units = "inches"}.}

\item{linecolor}{Character value indicating color of guideline.
Default value is \code{linecolor = "grey55"}.}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
None.
}
\description{
Draw a vertical guideline at a specified x-coordinate on a 
plotgardener page
}
\examples{
## Create a page
pageCreate(width = 6, height = 5, default.units = "inches")

## Add blue vertical guideline at x = 1.7 inches
pageGuideVertical(x = 1.7, linecolor = "blue")
}
