% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annoXaxis.R
\name{annoXaxis}
\alias{annoXaxis}
\title{Add an x-axis to a plot}
\usage{
annoXaxis(
    plot,
    at = NULL,
    label = TRUE,
    main = TRUE,
    scipen = 999,
    axisLine = FALSE,
    params = NULL,
    ...
)
}
\arguments{
\item{plot}{Plot object to annotate with x-axis.}

\item{at}{A numeric vector of x-value locations for tick marks.}

\item{label}{A logical value indicating whether to draw the labels on
the tick marks, or an expression or character vector which specify
the labels to use.
If not logical, must be the same length as the \code{at} argument.}

\item{main}{A logical value indicating whether to draw the x-axis at the
bottom of the plot. Default value is \code{main = TRUE}. Options are:
\itemize{
\item{\code{TRUE}: }{x-axis is drawn at the bottom of the plot.}
\item{\code{FALSE}: }{x-axis is drawn at the top of the plot.}
}}

\item{scipen}{An integer indicating the penalty to be applied when
deciding to print numeric values in fixed or exponential notation.
Default value is \code{scipen = 999}.}

\item{axisLine}{A logical value indicating whether to show the axis line.
Default value is \code{axisLine = FALSE}.}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}

\item{...}{Additional grid graphical parameters. See \link[grid]{gpar}.}
}
\value{
Returns a \code{xaxis} object containing
relevant \link[grid]{grob} information.
}
\description{
Add an x-axis to a plot
}
\examples{
## Load transcript information
library("TxDb.Hsapiens.UCSC.hg19.knownGene")
library("org.Hs.eg.db")

## Create page
pageCreate(width = 7.5, height = 4.5, default.units = "inches")

## Plot gene transcripts
transcriptPlot <- plotTranscripts(
    chrom = "chr1",
    chromstart = 1000000,
    chromend = 2000000,
    assembly = "hg19",
    x = 0.5, y = 0,
    width = 6.5, height = 4,
    just = c("left", "top"),
    default.units = "inches"
)

## Add standard x-axis to transcript plot
annoXaxis(
    plot = transcriptPlot,
    at = c(1000000, 1250000, 1500000, 1750000, 2000000),
    fontsize = 8
)
plotText(
    label = "Basepairs", fontsize = 10, fontface = "bold",
    x = 3.75, y = 4.3, just = "top"
)

## Hide page guides
pageGuideHide()
}
