% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance_sampler.R
\name{plasma_somatic}
\alias{plasma_somatic}
\title{Estimate the marginal likelihood that variants identified in
cell-free DNA are derived from tumor cells (ctDNA-derived)}
\usage{
plasma_somatic(dat, params)
}
\arguments{
\item{dat}{tibble containing vectors `y`and `n`; `y` and `n` should be named}

\item{params}{a list with named elements that must include the following:
`a`: prior expectation for number of plasma somatic variants
observed in the plasma sequencing data
`b`: prior expectation for number of plasma fragments 
not containing variants}
}
\value{
generate importance samples for plasma somatic model
}
\description{
Estimate the marginal likelihood that variants identified in
cell-free DNA are derived from tumor cells (ctDNA-derived)
}
\examples{
param.list <- list(ctc=list(a=1, b=9999),
                   ctdna=list(a=1, b=9),
                   chip=list(a=1, b=9),
                   montecarlo.samples=50e3,
                   prior.weight=0.1)
dat <- data.frame(y=c(4, 1),
              n=c(1000, 1000),
              analyte=c("plasma", "buffy coat"),
              mutation="mutA",
              sample_id="id1")
plasma_somatic(dat, param.list)
}
