% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_tf_counts.R
\name{get_tf_counts}
\alias{get_tf_counts}
\title{Get TF frequencies for each species as a SummarizedExperiment object}
\usage{
get_tf_counts(proteomes, species_metadata = NULL)
}
\arguments{
\item{proteomes}{List of \strong{AAStringSet} objects}

\item{species_metadata}{(Optional) A data frame containing species names
in row names (names must match element names in
the \strong{proteomes} list), and species metadata
(e.g., taxonomic information, ecological information)
in columns. If NULL, the colData of the SummarizedExperiment object
will be empty.}
}
\value{
A SummarizedExperiment object containing transcription factor
frequencies per family in each species, as well as species metadata (if
\strong{species_metadata} is not NULL).
}
\description{
This function identifies and classifies TFs, and returns TF counts for
each family as a SummarizedExperiment object
}
\examples{
data(gsu)

set.seed(123)
# Pick random subsets of 100 genes to simulate other species
proteomes <- list(
    Gsu1 = gsu[sample(names(gsu), 50, replace = FALSE)],
    Gsu2 = gsu[sample(names(gsu), 50, replace = FALSE)],
    Gsu3 = gsu[sample(names(gsu), 50, replace = FALSE)],
    Gsu4 = gsu[sample(names(gsu), 50, replace = FALSE)]
)

# Create species metadata
species_metadata <- data.frame(
    row.names = names(proteomes),
    Division = "Rhodophyta",
    Origin = c("US", "Belgium", "China", "Brazil")
)

# Get SummarizedExperiment object
if(hmmer_is_installed()) {
    se <- get_tf_counts(proteomes, species_metadata)
}
}
