% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrna_evaluationFunctions.R
\name{evaluateNorm}
\alias{evaluateNorm}
\title{evaluateNorm}
\usage{
evaluateNorm(x, clusters = NULL, covars)
}
\arguments{
\item{x}{An object of class 'Seurat' or 'SingleCellExperiment' with 
normalized data}

\item{clusters}{A vector of true cluster identities. If missing, will 
attempt to fetch it from the `phenoid` colData.}

\item{covars}{Covariates to include, either as data.frame or as colData
columns of `x`}
}
\value{
a data.frame.
}
\description{
evaluateNorm
}
\examples{
# random data
library(scater)
sce <- logNormCounts(mockSCE(ngenes = 500))
sce <- addPerCellQC(sce)
# random population labels
sce$cluster <- sample(LETTERS[1:3], ncol(sce), replace=TRUE)
evaluateNorm(sce, sce$cluster, covars="detected")
}
