% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalHeatmap.R
\name{colCenterScale}
\alias{colCenterScale}
\title{colCenterScale}
\usage{
colCenterScale(
  x,
  centerFn = median,
  scaleFn = function(x, na.rm) median(abs(x), na.rm = na.rm)
)
}
\arguments{
\item{x}{A numeric matrix.}

\item{centerFn}{The function for calculating centers. Should accept the 
`na.rm` argument. E.g. `centerFn=mean` or `centerFn=median`.}

\item{scaleFn}{The function for calculating the (matrix-wise) scaling
factor. Should accept the `na.rm` argument. Default `median(abs(x))`.}
}
\value{
A scaled matrix of the same dimensions as `x`.
}
\description{
Matrix scaling by centering columns separately and then performing variance 
scaling on the whole matrix, in a NA-robust fashion. With the default 
arguments, the output will be the number of (matrix-)median absolute 
deviations from the column-median.
}
\examples{
# random data with column mean differences
d <- cbind(A=rnorm(5, 10, 2), B=rnorm(5, 20, 2), C=rnorm(5,30, 2))
colCenterScale(d)
}
