% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipelineDefinition.R
\name{addPipelineStep}
\alias{addPipelineStep}
\title{addPipelineStep}
\usage{
addPipelineStep(object, name, after = NULL, slots = list())
}
\arguments{
\item{object}{A \code{\link{PipelineDefinition}}}

\item{name}{The name of the step to add}

\item{after}{The name of the step after which to add the new step. If NULL,
will add the step at the beginning of the pipeline.}

\item{slots}{A optional named list with slots to fill for that step (i.e. 
`functions`, `evaluation`, `aggregation`, `descriptions` - will be parsed)}
}
\value{
A \code{\link{PipelineDefinition}}
}
\description{
Add a step to an existing \code{\link{PipelineDefinition}}
}
\examples{
pd <- mockPipeline()
pd
pd <- addPipelineStep(pd, name="newstep", after="step1", 
                      slots=list(description="Step that does nothing..."))
pd
}
\seealso{
\code{\link{PipelineDefinition}}, 
\code{\link{PipelineDefinition-methods}}
}
