% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo2sbp.R
\name{phylo2sbp}
\alias{phylo2sbp}
\title{Create Sequential Binary Partition from Phylogenetic Tree}
\usage{
phylo2sbp(tr)
}
\arguments{
\item{tr}{a \code{phylo} tree object with n leaves}
}
\value{
a n by n-1 matrix of the sequential binary partition sign matrix
}
\description{
This function converts a binary phylogenetic tree to sequential binary
parition to be used to then build an ILR basis for compositional
metagenomic data.
}
\details{
The choice of orientation for a balance (i.e., which of the two descendant
clades of an internal node is in the numerator or denominator of the
log-ratio) is given by the default of the function phangorn::Children
and that choise is used consistently throughout the philr package.
}
\examples{
tr <- named_rtree(5)
phylo2sbp(tr)
}
\references{
Schliep K.P. 2011. phangorn: phylogenetic analysis in R. 
Bioinformatics, 27(4) 592-593
}
\seealso{
\code{\link{philr}}
}
\author{
Justin Silverman
}
